/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.preferences;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.linuxtools.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.rpm.ui.editor.preferences.Messages;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MacroProposalsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public MacroProposalsPreferencePage() {
        super(0);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        MacroListEditor macroListEditor = new MacroListEditor("macroProposalsFilespath", Messages.MacroProposalsPreferencePage_0, this.getFieldEditorParent());
        this.addField((FieldEditor)macroListEditor);
        RadioGroupFieldEditor macroHoverListEditor = new RadioGroupFieldEditor("macroHoverViewContent", Messages.MacroProposalsPreferencePage_1, 1, (String[][])new String[][]{{Messages.MacroProposalsPreferencePage_2, "macroHoverViewDescription"}, {Messages.MacroProposalsPreferencePage_3, "macroHoverViewContent"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)macroHoverListEditor);
    }

    class MacroListEditor
    extends ListEditor {
        private List list;
        private Composite buttonBox;
        private Button addFileButton;
        private Button addDirButton;
        private Button removeButton;
        private Button upButton;
        private Button downButton;
        private SelectionListener selectionListener;

        public MacroListEditor(String name, String labelText, Composite parent) {
            this.init(name, labelText);
            this.createControl(parent);
            this.list = this.getListControl(parent);
        }

        protected String createList(String[] items) {
            StringBuilder path = new StringBuilder("");
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                path.append(item);
                path.append(";");
                ++n2;
            }
            return path.toString();
        }

        protected String getNewInputObject() {
            FileDialog dialog = new FileDialog(this.getShell());
            return dialog.open();
        }

        protected String getNewDirInputObject() {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            return dialog.open();
        }

        protected String[] parseString(String stringList) {
            StringTokenizer st = new StringTokenizer(stringList, ";\n\r");
            ArrayList<String> v = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                v.add(st.nextToken());
            }
            return v.toArray(new String[v.size()]);
        }

        private void addFilePressed() {
            this.setPresentsDefaultValue(false);
            String input = this.getNewInputObject();
            if (input != null) {
                int index = this.list.getSelectionIndex();
                if (index >= 0) {
                    this.list.add(input, index + 1);
                } else {
                    this.list.add(input, 0);
                }
                this.selectionChanged();
            }
        }

        private void addDirPressed() {
            this.setPresentsDefaultValue(false);
            String input = this.getNewDirInputObject();
            if (input != null) {
                int index = this.list.getSelectionIndex();
                if (index >= 0) {
                    this.list.add(input, index + 1);
                } else {
                    this.list.add(input, 0);
                }
                this.selectionChanged();
            }
        }

        private void createButtons(Composite box) {
            this.addFileButton = this.createPushButton(box, Messages.MacroProposalsPreferencePage_4);
            this.addDirButton = this.createPushButton(box, Messages.MacroProposalsPreferencePage_5);
            this.removeButton = this.createPushButton(box, "ListEditor.remove");
            this.upButton = this.createPushButton(box, "ListEditor.up");
            this.downButton = this.createPushButton(box, "ListEditor.down");
        }

        private Button createPushButton(Composite parent, String key) {
            Button button = new Button(parent, 8);
            button.setText(JFaceResources.getString((String)key));
            button.setFont(parent.getFont());
            GridData data = new GridData(768);
            int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
            data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
            button.setLayoutData((Object)data);
            button.addSelectionListener(this.getSelectionListener());
            return button;
        }

        public void createSelectionListener() {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == MacroListEditor.this.addFileButton) {
                        MacroListEditor.this.addFilePressed();
                    } else if (widget == MacroListEditor.this.addDirButton) {
                        MacroListEditor.this.addDirPressed();
                    } else if (widget == MacroListEditor.this.removeButton) {
                        MacroListEditor.this.removePressed();
                    } else if (widget == MacroListEditor.this.upButton) {
                        MacroListEditor.this.upPressed();
                    } else if (widget == MacroListEditor.this.downButton) {
                        MacroListEditor.this.downPressed();
                    } else if (widget == MacroListEditor.this.list) {
                        MacroListEditor.this.selectionChanged();
                    }
                }
            };
        }

        private void downPressed() {
            this.swap(false);
        }

        public Composite getButtonBoxControl(Composite parent) {
            if (this.buttonBox == null) {
                this.buttonBox = new Composite(parent, 0);
                GridLayout layout = new GridLayout();
                layout.marginWidth = 0;
                this.buttonBox.setLayout((Layout)layout);
                this.createButtons(this.buttonBox);
                this.buttonBox.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        MacroListEditor.this.addFileButton = null;
                        MacroListEditor.this.addDirButton = null;
                        MacroListEditor.this.removeButton = null;
                        MacroListEditor.this.upButton = null;
                        MacroListEditor.this.downButton = null;
                        MacroListEditor.this.buttonBox = null;
                    }
                });
            } else {
                this.checkParent((Control)this.buttonBox, parent);
            }
            this.selectionChanged();
            return this.buttonBox;
        }

        public final List getListControl(Composite parent) {
            if (this.list == null) {
                this.list = new List(parent, 2820);
                this.list.setFont(parent.getFont());
                this.list.addSelectionListener(this.getSelectionListener());
                this.list.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event) {
                        MacroListEditor.this.list = null;
                    }
                });
            } else {
                this.checkParent((Control)this.list, parent);
            }
            return this.list;
        }

        private SelectionListener getSelectionListener() {
            if (this.selectionListener == null) {
                this.createSelectionListener();
            }
            return this.selectionListener;
        }

        protected Shell getShell() {
            if (this.addFileButton == null) {
                return null;
            }
            return this.addFileButton.getShell();
        }

        private void removePressed() {
            this.setPresentsDefaultValue(false);
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.remove(index);
                this.selectionChanged();
            }
        }

        protected void selectionChanged() {
            int index = this.list.getSelectionIndex();
            int size = this.list.getItemCount();
            this.removeButton.setEnabled(index >= 0);
            this.upButton.setEnabled(size > 1 && index > 0);
            this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
        }

        private void swap(boolean up) {
            int target;
            this.setPresentsDefaultValue(false);
            int index = this.list.getSelectionIndex();
            int n = target = up ? index - 1 : index + 1;
            if (index >= 0) {
                String[] selection = this.list.getSelection();
                Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
                this.list.remove(index);
                this.list.add(selection[0], target);
                this.list.setSelection(target);
            }
            this.selectionChanged();
        }

        private void upPressed() {
            this.swap(true);
        }

        public void setEnabled(boolean enabled, Composite parent) {
            super.setEnabled(enabled, parent);
            this.getListControl(parent).setEnabled(enabled);
            this.addFileButton.setEnabled(enabled);
            this.addDirButton.setEnabled(enabled);
            this.removeButton.setEnabled(enabled);
            this.upButton.setEnabled(enabled);
            this.downButton.setEnabled(enabled);
        }
    }
}

