/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.editor.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class AuthorEmailRule
implements IPredicateRule {
    private StringBuilder fBuffer = new StringBuilder();
    IToken token;
    protected static final char START_CHAR = '<';
    protected static final char END_CHAR = '>';
    protected static final char[] INTER_CHARS = new char[]{'@', '.'};
    protected static final int STATE_START = 0;
    protected static final int STATE_OPENED = 1;
    protected static final int STATE_AT = 2;
    protected static final int STATE_PERIOD = 3;
    protected static final int STATE_DONE = 4;

    public AuthorEmailRule(IToken token) {
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int state = 0;
        this.fBuffer.setLength(0);
        do {
            int c = scanner.read();
            this.fBuffer.append((char)c);
            if (c == -1 || (char)c == '\n') {
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            if (state == 0 && (char)c == '<') {
                ++state;
                continue;
            }
            if (state == 1) {
                if ((char)c == INTER_CHARS[0]) {
                    ++state;
                }
                if (Character.isLetterOrDigit((char)c) || c == 46 || c == 95 || c == 45 || c == 64) continue;
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            if (state == 2) {
                if ((char)c == INTER_CHARS[1]) {
                    ++state;
                }
                if (Character.isLetterOrDigit((char)c) || c == 46 || c == 95 || c == 45) continue;
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            if (state == 3) {
                if ((char)c == '>' && this.fBuffer.charAt(this.fBuffer.length() - 1) != '.') {
                    ++state;
                    continue;
                }
                if ((char)c != '>') continue;
                this.unreadBuffer(scanner, this.fBuffer);
                return Token.UNDEFINED;
            }
            this.unreadBuffer(scanner, this.fBuffer);
            return Token.UNDEFINED;
        } while (state != 4);
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    protected void unreadBuffer(ICharacterScanner scanner, StringBuilder buffer) {
        int i = buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

