/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.linuxtools.internal.rpm.ui.editor.ColorManager;
import org.eclipse.linuxtools.internal.rpm.ui.editor.ISpecfileColorConstants;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileCompletionProcessor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileDoubleClickStrategy;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileHover;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileReconcilingStrategy;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfileChangelogScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePackagesScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfilePartitionScanner;
import org.eclipse.linuxtools.internal.rpm.ui.editor.scanners.SpecfileScanner;
import org.eclipse.linuxtools.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class SpecfileConfiguration
extends TextSourceViewerConfiguration {
    private SpecfileDoubleClickStrategy doubleClickStrategy;
    private SpecfileScanner scanner;
    private SpecfileChangelogScanner changelogScanner;
    private SpecfilePackagesScanner packagesScanner;
    private ColorManager colorManager;
    private SpecfileHover specfileHover;
    private SpecfileEditor editor;

    public SpecfileConfiguration(ColorManager colorManager, SpecfileEditor editor) {
        this.colorManager = colorManager;
        this.editor = editor;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return SpecfilePartitionScanner.SPEC_PARTITION_TYPES;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new SpecfileDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected SpecfileScanner getSpecfileScanner() {
        if (this.scanner == null) {
            this.scanner = new SpecfileScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISpecfileColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    protected SpecfileChangelogScanner getSpecfileChangelogScanner() {
        if (this.changelogScanner == null) {
            this.changelogScanner = new SpecfileChangelogScanner(this.colorManager);
            this.changelogScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISpecfileColorConstants.DEFAULT))));
        }
        return this.changelogScanner;
    }

    protected SpecfilePackagesScanner getSpecfilePackagesScanner() {
        if (this.packagesScanner == null) {
            this.packagesScanner = new SpecfilePackagesScanner(this.colorManager);
            this.packagesScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(ISpecfileColorConstants.DEFAULT))));
        }
        return this.packagesScanner;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.specfileHover == null) {
            this.specfileHover = new SpecfileHover(this.editor);
        }
        return this.specfileHover;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfilePackagesScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_packages");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_packages");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_prep");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_prep");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_script");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_script");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_files");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_files");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_group");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_group");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSpecfileChangelogScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__spec_changelog");
        reconciler.setRepairer((IPresentationRepairer)dr, "__spec_changelog");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor != null && this.editor.isEditable()) {
            SpecfileReconcilingStrategy strategy = new SpecfileReconcilingStrategy(this.editor);
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        SpecfileCompletionProcessor processor = new SpecfileCompletionProcessor(this.editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_prep");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_script");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_files");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_changelog");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_packages");
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__spec_group");
        assistant.setContextInformationPopupOrientation(20);
        IInformationControlCreator controlCreator = this.getInformationControlCreator();
        assistant.setInformationControlCreator(controlCreator);
        assistant.enableAutoInsert(true);
        assistant.setStatusLineVisible(true);
        assistant.setStatusMessage(Messages.SpecfileConfiguration_0);
        return assistant;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, false);
            }
        };
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return this.getRegisteredHyperlinkDetectors(sourceViewer);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.linuxtools.rpm.ui.editor.SpecfileEditorTarget", this.editor);
        targets.put("org.eclipse.ui.DefaultTextEditor", this.editor);
        return targets;
    }

    private int getTabSize() {
        return Activator.getDefault().getPreferenceStore().getInt("NbrOfSpacesForTab");
    }

    private boolean isTabConversionEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean("SpacesForTabs");
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.isTabConversionEnabled()) {
            TabsToSpacesConverter tabsConverter = new TabsToSpacesConverter();
            tabsConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            tabsConverter.setNumberOfSpacesPerTab(this.getTabSize());
            return new IAutoEditStrategy[]{tabsConverter};
        }
        return null;
    }
}

