/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import org.polarsys.time4sys.builder.design.CommunicationStepBuilder;
import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.SchedulableResourceBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.design.DesignFactory;
import org.polarsys.time4sys.marte.gqam.CommunicationChannel;
import org.polarsys.time4sys.marte.gqam.GqamFactory;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.grm.GrmFactory;
import org.polarsys.time4sys.marte.grm.SchedulingParameter;
import org.polarsys.time4sys.marte.hrm.HrmFactory;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.srm.SrmFactory;

public class CommunicationChannelBuilder
implements SchedulableResourceBuilder<CommunicationChannel, CommunicationChannelBuilder> {
    protected static DesignFactory df = DesignFactory.eINSTANCE;
    protected static GqamFactory gqamFactory = GqamFactory.eINSTANCE;
    protected static SrmFactory srmFactory = SrmFactory.eINSTANCE;
    protected static GrmFactory grmFactory = GrmFactory.eINSTANCE;
    protected static HrmFactory hrmFactory = HrmFactory.eINSTANCE;
    protected static NfpFactory nfpFactory = NfpFactory.eINSTANCE;
    private String period;
    private CommunicationChannel task;
    private StepBuilder firstStep;
    private DesignBuilder design;
    private String wcet;
    private String bcet;
    private String jitter;
    private int nbEvents = 1;
    private String windowSize;
    private Boolean isAtomic = null;

    public static CommunicationChannelBuilder aMessage() {
        return new CommunicationChannelBuilder();
    }

    public CommunicationChannelBuilder() {
        this(null, gqamFactory.createCommunicationChannel());
    }

    public CommunicationChannelBuilder(DesignBuilder designBuilder, CommunicationChannel raw) {
        assert (raw != null);
        this.task = raw;
        this.design = designBuilder;
    }

    @Override
    public CommunicationChannel build(DesignBuilder design) {
        this.design = design;
        if (this.period != null) {
            this.firstStep().isPeriodic(this.period);
        }
        if (this.windowSize != null) {
            this.firstStep().withSlidingWindow(this.nbEvents, this.windowSize);
        }
        if (this.jitter != null) {
            this.firstStep().hasJitter(this.jitter);
        }
        if (this.bcet != null) {
            this.firstStep().ofBCET(this.bcet);
        }
        if (this.wcet != null) {
            this.firstStep().ofWCET(this.wcet);
        }
        if (this.isAtomic != null) {
            this.firstStep().isAtomic(this.isAtomic);
        }
        return this.task;
    }

    public CommunicationChannelBuilder ofPeriod(String value) {
        this.period = value;
        return this;
    }

    public CommunicationChannelBuilder withSlidingWindow(int nbEvents, String windowSize) {
        this.nbEvents = nbEvents;
        this.windowSize = windowSize;
        this.period = null;
        return this;
    }

    public CommunicationChannelBuilder called(String value) {
        this.task.setName(value);
        return this;
    }

    public StepBuilder firstStep() {
        if (this.firstStep != null) {
            return this.firstStep;
        }
        if (this.design == null) {
            throw new IllegalStateException("Illegal API order of calls.");
        }
        for (Step step : this.design.allSteps()) {
            if (step.getConcurRes() != this.task) continue;
            if (step.getInputRel() != null) {
                while (!step.getInputRel().getPredec().isEmpty()) {
                    for (Step prec : step.getInputRel().getPredec()) {
                        if (prec.getConcurRes() != this.task) continue;
                        step = prec;
                    }
                }
            }
            return new CommunicationStepBuilder(this.design, this, step);
        }
        this.firstStep = new CommunicationStepBuilder(this.design, this);
        this.firstStep().called(this.task.getName());
        this.firstStep().build();
        return this.firstStep;
    }

    public StepBuilder anotherStep() {
        CommunicationStepBuilder res = new CommunicationStepBuilder(this.design, this);
        res.setChannel(this);
        return res;
    }

    public CommunicationChannelBuilder ofWCET(String value) {
        this.wcet = value;
        return this;
    }

    public CommunicationChannelBuilder ofBCET(String value) {
        this.bcet = value;
        return this;
    }

    public StepBuilder whoseFirstStep() {
        return this.firstStep();
    }

    public CommunicationChannelBuilder ofDeadline(String value) {
        this.getSchedParams("Deadline").setValue(value);
        return this;
    }

    public CommunicationChannelBuilder ofPriority(int value) {
        this.getSchedParams("FixedPriority").setValue(Integer.toString(value));
        return this;
    }

    public int getPriority() {
        return Integer.parseInt(this.getSchedParams("FixedPriority").getValue());
    }

    private SchedulingParameter getSchedParams(String key) {
        for (SchedulingParameter v : this.task.getSchedParams()) {
            if (!key.equals(v.getName())) continue;
            return v;
        }
        SchedulingParameter sp = grmFactory.createSchedulingParameter();
        sp.setName(key);
        this.task.getSchedParams().add((Object)sp);
        return sp;
    }

    public CommunicationChannelBuilder has(StepBuilder ... steps) {
        StepBuilder[] stepBuilderArray = steps;
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            StepBuilder step = stepBuilderArray[n2];
            step.setChannel(this);
            ++n2;
        }
        return this;
    }

    public CommunicationChannelBuilder ofET(String value) {
        return this.ofBCET(value).ofWCET(value);
    }

    public CommunicationChannelBuilder ofJitter(String value) {
        this.jitter = value;
        return this;
    }

    public CommunicationChannelBuilder nonPreemptive() {
        this.isAtomic = true;
        return this;
    }
}

