/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.simulation;

import org.polarsys.time4sys.builder.simulation.EventBuilder;
import org.polarsys.time4sys.builder.simulation.TraceBuilder;
import org.polarsys.time4sys.trace.SchedulingEvent;
import org.polarsys.time4sys.trace.SchedulingEventKind;
import org.polarsys.time4sys.trace.Slice;
import org.polarsys.time4sys.trace.SliceKind;
import org.polarsys.time4sys.trace.TraceFactory;

public class SliceBuilder {
    private Slice slice;
    private TraceBuilder trace;

    public SliceBuilder(TraceBuilder traceBuilder, Slice aSlice) {
        this.trace = traceBuilder;
        this.slice = aSlice;
    }

    public EventBuilder logEvent(SchedulingEventKind value) {
        SchedulingEvent evt = TraceFactory.eINSTANCE.createSchedulingEvent();
        evt.setKind(value);
        this.slice.getEvents().add((Object)evt);
        EventBuilder evtBuilder = new EventBuilder(this, evt);
        this.trace.hasEvent(evtBuilder);
        return evtBuilder;
    }

    public SliceBuilder hasJobSlice() {
        Slice jobSlice = TraceFactory.eINSTANCE.createSlice();
        this.slice.getOwnedSubSlices().add((Object)jobSlice);
        jobSlice.setKind(SliceKind.JOB);
        return new SliceBuilder(this.trace, jobSlice);
    }

    public SliceBuilder activatedAt(String pit) {
        this.logEvent(SchedulingEventKind.ACTIVATED).at(pit);
        return this;
    }

    public SliceBuilder startedAt(String pit) {
        this.logEvent(SchedulingEventKind.RUNNING).at(pit);
        return this;
    }

    public SliceBuilder endedAt(String pit) {
        this.logEvent(SchedulingEventKind.TERMINATED).at(pit);
        return this;
    }

    public SliceBuilder called(String name) {
        this.slice.setName(name);
        return this;
    }

    public SliceBuilder isConcernedBy(SliceBuilder subSlice) {
        this.slice.getSubSlices().add((Object)subSlice.build());
        return this;
    }

    public Slice build() {
        return this.slice;
    }

    public SliceBuilder ofKindPackage() {
        this.slice.setKindLabel("package");
        return this;
    }

    public SliceBuilder ofKind(SliceKind k) {
        this.slice.setKind(k);
        return this;
    }
}

