/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.time4sys.design.DesignModel;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.Mapping;
import org.polarsys.time4sys.mapping.MappingFactory;
import org.polarsys.time4sys.model.time4sys.Project;
import org.polarsys.time4sys.model.time4sys.Time4sysFactory;
import org.polarsys.time4sys.model.time4sys.Transformation;
import org.polarsys.time4sys.transformations.CopierMapper;

public class IdentityDerivation {
    public static final String ORIGINAL_ROLE = "original".intern();
    public static final String COPY_ROLE = "copy".intern();
    public static final String IDENTITY_RULE_NAME = "Identity Rule".intern();
    protected DesignModel source;
    protected Project project;
    protected Context identityRule;
    protected Mapping mapping;
    protected CopierMapper copierMapper;
    protected static final MappingFactory mappingFactory = MappingFactory.eINSTANCE;

    public static Transformation duplicate(Project project, DesignModel source) {
        return new IdentityDerivation(project, source).transform();
    }

    public IdentityDerivation(Project project, DesignModel source) {
        this.source = source;
        this.project = project;
    }

    public Transformation transform() {
        this.mapping = mappingFactory.createMapping();
        this.mapping.getSources().add((Object)mappingFactory.createResourceArtefact(ORIGINAL_ROLE, this.source.eResource()));
        this.createRules();
        DesignModel target = this.copy();
        Transformation transformation = Time4sysFactory.eINSTANCE.createTransformation();
        if (this.project != null) {
            this.project.getTransformations().add((Object)transformation);
        }
        transformation.setMapping(this.mapping);
        transformation.setResult((EObject)target);
        this.mapping.getTargets().add((Object)mappingFactory.createResourceArtefact(COPY_ROLE, target.eResource()));
        this.finalize(target);
        return transformation;
    }

    protected void finalize(DesignModel target) {
    }

    public void createRules() {
        this.identityRule = mappingFactory.createContext(IDENTITY_RULE_NAME);
        this.mapping.getRules().add((Object)this.identityRule);
    }

    public DesignModel copy() {
        this.copierMapper = this.createCopierMapper();
        DesignModel target = this.copierMapper.copyAndMap(this.source);
        return target;
    }

    public CopierMapper createCopierMapper() {
        CopierMapper copierMapper = new CopierMapper(this.mapping, this.identityRule);
        return copierMapper;
    }

    public Link getUniqueLinkFor(EObject key) {
        List<Link> links = this.copierMapper.getLinksFor(key);
        assert (!links.isEmpty());
        assert (links.size() == 1);
        Link copyLnk = links.get(0);
        return copyLnk;
    }
}

