/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.controls;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.preferences.PreferenceHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Ttcn3HoverContent {
    private static final String LINK_PATTERN = "<a href=\"{0}\">{0}</a>";
    private static final String ICON_PATTERN = "<div class=\"title-with-icon\"><img src=\"{0}\"><span style=\"margin-left: 5px\">";
    private static final String DIV_END = "</div>";
    private static final String SPAN_END = "</span>";
    private static final String DIV_TAG = "<div class=\"tag\">";
    private static final String DIV_INDENTED = "<div class=\"indented-block\">";
    private StringBuilder sb = new StringBuilder();
    private StringBuilder bufferSb = new StringBuilder();
    private Map<HoverContentType, String> map = new HashMap<HoverContentType, String>();
    private boolean hasIcon = false;

    public Ttcn3HoverContent() {
    }

    public Ttcn3HoverContent(String text) {
        this(HoverContentType.INFO, text);
    }

    public Ttcn3HoverContent(HoverContentType type, String text) {
        this.addContent(type, text);
    }

    public void addContent(HoverContentType type, String text) {
        if (text == null || text.isEmpty()) {
            this.map.put(type, text);
            return;
        }
        this.sb = new StringBuilder(text);
        this.addContent(type);
    }

    public void addContent(HoverContentType type) {
        this.map.put(type, this.sb.toString());
        this.sb.setLength(0);
    }

    public boolean hasText(HoverContentType type) {
        return this.map.get((Object)type) != null;
    }

    public String getText(HoverContentType type) {
        return this.getText(type, false);
    }

    public String getText(HoverContentType type, boolean isDocView) {
        String url = null;
        switch (ColorManager.getColorTheme()) {
            case Dark: {
                url = this.getStyleSheetUrl("HoverInfoDark.css");
                break;
            }
            default: {
                url = this.getStyleSheetUrl("HoverInfo.css");
            }
        }
        StringBuilder styled = new StringBuilder();
        if (url != null) {
            styled.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
            styled.append(url);
            styled.append("\">");
        } else {
            styled.append((CharSequence)this.sb);
        }
        Color background = null;
        background = isDocView ? PreferenceHandler.getEditorBackgroundColor() : ColorManager.getInformationBackgroundColor();
        styled.append("<style>body { background-color: rgb(");
        styled.append(background.getRed()).append(", ").append(background.getGreen()).append(", ").append(background.getBlue()).append("); }</style>");
        String text = styled.append(this.map.get((Object)type)).toString();
        if (text != null) {
            return text.replace("@@", "@");
        }
        return null;
    }

    public Ttcn3HoverContent addText(String text) {
        this.sb.append(text);
        return this;
    }

    public Ttcn3HoverContent addTag(String text) {
        this.sb.append(DIV_TAG).append(text).append(DIV_END);
        return this;
    }

    public Ttcn3HoverContent addTagWithText(String tag, String text) {
        this.sb.append(DIV_TAG).append(tag).append("<span class=\"tagtext\">").append(text).append(SPAN_END).append(DIV_END);
        return this;
    }

    public Ttcn3HoverContent addStyledText(String text) {
        this.bufferSb.append(text);
        return this;
    }

    public Ttcn3HoverContent addStyledText(String text, int style, boolean isIndented) {
        boolean isItalic = false;
        boolean isBold = false;
        if ((style & 2) != 0) {
            isItalic = true;
        }
        if ((style & 1) != 0) {
            isBold = true;
        }
        if (isIndented) {
            this.sb.append(DIV_INDENTED);
        }
        if (isItalic) {
            this.sb.append("<i>");
        }
        if (isBold) {
            this.sb.append("<b>");
        }
        this.sb.append((CharSequence)this.bufferSb).append(text);
        if (isBold) {
            this.sb.append("</b>");
        }
        if (isItalic) {
            this.sb.append("</i>");
        }
        if (isIndented) {
            this.sb.append(DIV_END);
        }
        this.bufferSb.setLength(0);
        return this;
    }

    public Ttcn3HoverContent addStyledText(String text, int style) {
        return this.addStyledText(text, style, false);
    }

    public Ttcn3HoverContent addIndentedText(String text) {
        return this.addIndentedText(text, 0);
    }

    public Ttcn3HoverContent addIndentedText(String text, int style) {
        return this.addStyledText(text, style, true);
    }

    public Ttcn3HoverContent addIndentedText(String indentTo, String textToIndent) {
        if (indentTo == null || textToIndent == null) {
            return this;
        }
        this.sb.append("<div class=\"list-title\">").append(indentTo).append(DIV_END).append(DIV_INDENTED).append(textToIndent).append(DIV_END);
        return this;
    }

    public Ttcn3HoverContent addUrlAsLink(String url) {
        return this.addUrlAsLink(url, 0);
    }

    public Ttcn3HoverContent addUrlAsLink(String url, int style) {
        if (url == null || url.isEmpty()) {
            return this;
        }
        return this.addIndentedText(MessageFormat.format(LINK_PATTERN, url), style);
    }

    public Ttcn3HoverContent addIcon(String iconUri) {
        if (iconUri == null || iconUri.isEmpty()) {
            return this;
        }
        this.hasIcon = true;
        return this.addText(MessageFormat.format(ICON_PATTERN, this.getIconUrl(iconUri)));
    }

    public Ttcn3HoverContent addDeprecated() {
        return this.addStyledText("This object is deprecated<br><br>", 2);
    }

    public boolean hasIcon() {
        return this.hasIcon;
    }

    public Ttcn3HoverContent closeHeader() {
        if (this.hasIcon) {
            this.sb.append(SPAN_END).append(DIV_END);
        }
        return this;
    }

    private String getStyleSheetUrl(String css) {
        return this.getUrl("css", css);
    }

    private String getIconUrl(String icon) {
        return this.getUrl("icons", icon);
    }

    private String getUrl(String dir, String filename) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Path path = new Path(dir + "/" + filename);
        URL fileURL = FileLocator.find((Bundle)bundle, (IPath)path, null);
        URL fileURL2 = null;
        try {
            fileURL2 = FileLocator.toFileURL((URL)fileURL);
        }
        catch (IOException e) {
            return null;
        }
        return "file:" + fileURL2.getFile();
    }
}

