/********************************************************************************
 * Copyright (c) 2007 IBM Corporation and others. All rights reserved.
 * This program and the accompanying materials are made available under the terms
 * of the Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Initial Contributors:
 * The following IBM employees contributed to the Remote System Explorer
 * component that contains this file: David McKnight.
 * 
 * Contributors:
 * Martin Oberhuber (Wind River) - [177523] Unify singleton getter methods
 ********************************************************************************/

package org.eclipsecon.tmtutorial.host;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;


public class CreateEclipseHostActionDelegate implements IViewActionDelegate {
    public IViewPart view;

	
    /**
     * Creates a new ViewActionDelegate.
     */
    public CreateEclipseHostActionDelegate() {
        super();
    }

    /* (non-Javadoc)
     * Method declared on IViewActionDelegate
     */
    public void init(IViewPart view) {
        this.view = view;
    }

    /* (non-Javadoc)
     * Method declared on IActionDelegate
     */
    public void run(org.eclipse.jface.action.IAction action) 
    {
    	// the host we want to connect to
    	String hostName = "build.eclipse.org"; //$NON-NLS-1$
		
    	// get the singleton RSE registry
		ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
		
		// get the default profile, used to store connections
		ISystemProfile profile = registry.getSystemProfileManager().getDefaultPrivateSystemProfile();
		
		// see if a host object already exists for "build.eclipse.org"
		IHost host = registry.getHost(profile, hostName);
		if (host == null)
		{
			// if there's no host then we will create it
			try
			{
				IRSESystemType sysType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.ssh"); //$NON-NLS-1$
				// create the host object as an SSH Only connection
			    host = registry.createHost(
			    		sysType,	//System Type Name	//$NON-NLS-1$
			    		hostName,	//Connection name
			    		hostName,	//IP Address		
			    		"Connection to Eclipse build site"); //description //$NON-NLS-1$
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			if (host == null)
				return;
		}

		// example of using property sets
		IConnectorService[] conServices = host.getConnectorServices();
		if (conServices != null && conServices.length > 0)
		{
			IPropertySet set = null;
			IPropertySet[] sets = conServices[0].getPropertySets();
			if (sets != null && sets.length > 0)
			{
				set = sets[0];				
			}
			else
			{
				set = new PropertySet("System Info");
				conServices[0].addPropertySet(set);
			}
			set.addProperty("Arch", "PPC 64");
		}
    }

    /* (non-Javadoc)
     * Method declared on IActionDelegate
     */
    public void selectionChanged(org.eclipse.jface.action.IAction action,
            org.eclipse.jface.viewers.ISelection selection) 
    {
        // do nothing
    }
}
