/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.timing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.trace4cps.analysis.timing.StatisticsManager;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.TraceHelper;

public class TimingAnalysis {
    private TimingAnalysis() {
    }

    public static Map<String, StatisticsManager> analyse(ITrace trace, Collection<String> claimGroupingAttributes) {
        HashMap<String, StatisticsManager> r = new HashMap<String, StatisticsManager>();
        Map<String, List<IClaim>> p = TimingAnalysis.createPartition(trace, claimGroupingAttributes);
        for (Map.Entry<String, List<IClaim>> e : p.entrySet()) {
            String name = e.getKey();
            StatisticsManager stat = new StatisticsManager(trace.getTimeUnit());
            r.put(name, stat);
            List<IClaim> claims = e.getValue();
            for (IClaim c : claims) {
                double t = BigDecimal.valueOf(c.getEndTime().doubleValue()).subtract(BigDecimal.valueOf(c.getStartTime().doubleValue())).doubleValue();
                stat.addSample(t);
            }
            stat.autoScale();
        }
        return r;
    }

    private static Map<String, List<IClaim>> createPartition(ITrace trace, Collection<String> claimGroupingAttributes) {
        HashMap<String, List<IClaim>> p = new HashMap<String, List<IClaim>>();
        for (IClaim c : trace.getClaims()) {
            String attVals = TraceHelper.getValues(c, claimGroupingAttributes, false);
            ArrayList<IClaim> cell = (ArrayList<IClaim>)p.get(attVals);
            if (cell == null) {
                cell = new ArrayList<IClaim>();
                p.put(attVals, cell);
            }
            cell.add(c);
        }
        return p;
    }
}

