/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.behavior;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.behavior.Behavior;
import org.eclipse.trace4cps.core.IEvent;

public class HistogramEntry {
    private final Map<String, String> common = new HashMap<String, String>();
    private final Set<Integer> objectIds = new HashSet<Integer>();
    private final int size;

    HistogramEntry(List<Behavior> cell) {
        this.size = cell.size();
        for (Behavior b : cell) {
            this.objectIds.add(b.getValue());
        }
        boolean first = true;
        for (Behavior b : cell) {
            for (IEvent e : b.getEvents()) {
                if (first) {
                    this.common.putAll(e.getAttributes());
                    first = false;
                } else {
                    this.intersectAttributes(e);
                }
                if (!this.common.isEmpty()) continue;
                return;
            }
        }
    }

    private void intersectAttributes(IEvent event) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.common.entrySet()) {
            if (e.getValue().equals(event.getAttributeValue(e.getKey()))) continue;
            keysToRemove.add(e.getKey());
        }
        for (String k : keysToRemove) {
            this.common.remove(k);
        }
    }

    public Map<String, String> getCommonAttributeValues() {
        return Collections.unmodifiableMap(this.common);
    }

    public Set<Integer> getCentralObjectIds() {
        return this.objectIds;
    }

    public String toString() {
        return "HistogramEntry[size=" + this.size + "]";
    }

    public int size() {
        return this.size;
    }
}

