/*
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

package org.eclipse.trace4cps.core;

/**
 * A generic filter interface to filter parts of the TRACE data model which are based on the {@link IAttributeAware}
 * interface.
 */
public interface IAttributeFilter {
    /**
     * @param a the TRACE part to evaluate
     * @return whether to include the given TRACE part
     */
    boolean include(IAttributeAware a);
}
