/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.plot;

import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.general.DatasetUtils;
import org.jfree.data.xy.XYDataset;

public class PlotUtils {
    private PlotUtils() {
    }

    public static boolean isEmptyOrNull(XYPlot plot) {
        return plot == null || plot.getDatasets().values().stream().allMatch(DatasetUtils::isEmptyOrNull);
    }

    public static int getItemCount(XYPlot plot) {
        int itemCount = 0;
        int d = 0;
        while (d < plot.getDatasetCount()) {
            XYDataset dataset = plot.getDataset(d);
            int s = 0;
            while (s < dataset.getSeriesCount()) {
                itemCount += dataset.getItemCount(s);
                ++s;
            }
            ++d;
        }
        return itemCount;
    }

    public static List<XYItemRenderer> getAllRenderers(XYPlot plot) {
        ArrayList<XYItemRenderer> renderers = new ArrayList<XYItemRenderer>(plot.getRenderers().values());
        if (plot instanceof CombinedRangeXYPlot) {
            ((CombinedRangeXYPlot)plot).getSubplots().forEach(p -> {
                boolean bl = renderers.addAll(PlotUtils.getAllRenderers(p));
            });
        } else if (plot instanceof CombinedDomainXYPlot) {
            ((CombinedDomainXYPlot)plot).getSubplots().forEach(p -> {
                boolean bl = renderers.addAll(PlotUtils.getAllRenderers(p));
            });
        }
        return renderers;
    }
}

