/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.data.xy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.trace4cps.common.jfreechart.data.xy.XYEdgeSeries;
import org.jfree.chart.util.Args;
import org.jfree.chart.util.PublicCloneable;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class XYEdgeSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
VetoableChangeListener,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -371610910545736704L;
    private final ArrayList<XYEdgeSeries> data = new ArrayList();

    public XYEdgeSeriesCollection() {
    }

    public XYEdgeSeriesCollection(XYEdgeSeries series) {
        this.addSeries(series);
    }

    public void addSeries(XYEdgeSeries series) {
        Args.nullNotPermitted((Object)((Object)series), (String)"series");
        this.data.add(series);
        series.addChangeListener((SeriesChangeListener)this);
        series.addVetoableChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeAllSeries() {
        this.data.forEach(s -> s.removeChangeListener((SeriesChangeListener)this));
        this.data.clear();
        this.fireDatasetChanged();
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public XYEdgeSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.data.get(series);
    }

    public int getSeriesIndex(Comparable<?> key) {
        Args.nullNotPermitted(key, (String)"key");
        int seriesCount = this.getSeriesCount();
        int i = 0;
        while (i < seriesCount) {
            XYEdgeSeries series = this.data.get(i);
            if (key.equals(series.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Comparable<?> getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    public Number getX(int series, int item) {
        return this.getSeries(series).getX(item);
    }

    public Number getY(int series, int item) {
        return this.getSeries(series).getY(item);
    }

    public Number getStartX(int series, int item) {
        return this.getSeries(series).getStartX(item);
    }

    public Number getEndX(int series, int item) {
        return this.getSeries(series).getEndX(item);
    }

    public Number getStartY(int series, int item) {
        return this.getSeries(series).getStartY(item);
    }

    public Number getEndY(int series, int item) {
        return this.getSeries(series).getEndY(item);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (!"Key".equals(e.getPropertyName())) {
            return;
        }
        XYEdgeSeries s = (XYEdgeSeries)((Object)e.getSource());
        if (this.getSeriesIndex(s.getKey()) == -1) {
            throw new IllegalStateException("Receiving events from a series that does not belong to this collection.");
        }
        Comparable key = (Comparable)e.getNewValue();
        if (this.getSeriesIndex(key) >= 0) {
            throw new PropertyVetoException("Duplicate key2", e);
        }
    }
}

