/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.scripting.ui.tracemarker;

import java.util.HashMap;
import java.util.Objects;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.scripting.ui.tracemarker.ScriptingMarkerSource;
import org.eclipse.tracecompass.incubator.internal.scripting.ui.tracemarker.TraceMarker;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceAdapterManager;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;

public class TraceMarkerScriptingModule {
    private static final String DEFAULT_ENDTIME = "-1";
    private static final String DEFAULT_LABEL = "TraceMarker";
    private static final String DEFAULT_CATEGORY = "Generals markers";
    private static final String DEFAULT_COLOR = "Red";
    private static final String INVALID_START_TIMESTAMP = "Invalid start time. Start time before end of trace (marker start time %d, start of trace %d)";
    private static final String INVALID_END_TIMESTAMP = "Invalid end time. End time before start time (start %d, end %d)";
    private static final String INVALID_END_TIMESTAMP_2 = "Invalid end time. End time beyond end of trace (marker end time %d, end of trace %d)";
    private static final String INVALID_TRACE = "Non-existing or invalid trace: open or reaload the trace!";
    private final HashMap<ITmfTrace, ScriptingMarkerSource> fScriptingMarkerSourceMap = new HashMap();

    @WrapToScript
    public void addTraceMarker(ITmfTrace trace, long startTime, @ScriptParameter(defaultValue="-1") long endTime, @ScriptParameter(defaultValue="TraceMarker") @Nullable String label, @ScriptParameter(defaultValue="Generals markers") @Nullable String category, @ScriptParameter(defaultValue="Red") @Nullable String color) throws NullPointerException, IllegalArgumentException {
        ScriptingMarkerSource source = this.getMarkerSource(trace);
        if (source == null) {
            try {
                source = this.findMarkerSourceFromAdapters(trace);
                if (source == null) {
                    source = this.createMarkerSource(trace);
                }
            }
            catch (NullPointerException e) {
                throw new NullPointerException(INVALID_TRACE);
            }
        }
        try {
            TraceMarker traceMarker = TraceMarkerScriptingModule.createTraceMarker(trace, label, category, startTime, endTime, color);
            source.configureMarker(traceMarker);
        }
        catch (IllegalArgumentException e) {
            String markerName = label == null ? DEFAULT_LABEL : label;
            String exceptionMessage = e + " for marker : " + markerName + " at " + startTime;
            throw new IllegalArgumentException(exceptionMessage, e);
        }
    }

    private static TraceMarker createTraceMarker(ITmfTrace trace, @Nullable String label, @Nullable String category, long startTime, long endTime, @Nullable String color) {
        long tStartTime = startTime;
        long tEndTime = endTime;
        String tLabel = label;
        String tCategory = category;
        String tColor = color;
        if (tEndTime == Long.parseLong(DEFAULT_ENDTIME)) {
            tEndTime = tStartTime;
        }
        if (tStartTime > tEndTime) {
            throw new IllegalArgumentException(String.format(INVALID_END_TIMESTAMP, tStartTime, tEndTime));
        }
        if (tEndTime > trace.getEndTime().toNanos()) {
            throw new IllegalArgumentException(String.format(INVALID_END_TIMESTAMP_2, tEndTime, trace.getEndTime().toNanos()));
        }
        if (tStartTime < trace.getStartTime().toNanos()) {
            throw new IllegalArgumentException(String.format(INVALID_START_TIMESTAMP, tStartTime, trace.getStartTime().toNanos()));
        }
        if (tLabel == null) {
            tLabel = DEFAULT_LABEL;
        }
        if (tCategory == null) {
            tCategory = DEFAULT_CATEGORY;
        }
        if (tColor == null) {
            tColor = DEFAULT_COLOR;
        }
        return new TraceMarker(tLabel, tCategory, tStartTime, tEndTime, tColor);
    }

    private @Nullable ScriptingMarkerSource getMarkerSource(ITmfTrace trace) {
        return this.fScriptingMarkerSourceMap.get(trace);
    }

    private @Nullable ScriptingMarkerSource findMarkerSourceFromAdapters(ITmfTrace trace) {
        for (IMarkerEventSource source : TmfTraceAdapterManager.getAdapters((ITmfTrace)trace, IMarkerEventSource.class)) {
            ScriptingMarkerSource markerSource;
            if (!(source instanceof ScriptingMarkerSource) || !Objects.equals((markerSource = (ScriptingMarkerSource)source).getTrace(), trace)) continue;
            markerSource.initializeAdapterMarkersLists();
            this.fScriptingMarkerSourceMap.put(trace, markerSource);
            return markerSource;
        }
        return null;
    }

    private ScriptingMarkerSource createMarkerSource(ITmfTrace trace) {
        ScriptingMarkerSource markerSource = new ScriptingMarkerSource(trace);
        this.fScriptingMarkerSourceMap.put(trace, markerSource);
        return markerSource;
    }
}

