/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.cpuusage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageStateProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.tid.TidAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.KernelEventLayoutRequirement;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KernelCpuUsageAnalysis
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.cpuusage";
    public static final String TOTAL = "total";
    public static final String SPLIT_STRING = "/";
    public static final String TID_ZERO = "0";
    private static final KernelEventLayoutRequirement LAYOUT_REQUIREMENT;
    private static final SetMultimap<IKernelAnalysisEventLayout, TmfAbstractAnalysisRequirement> LAYOUT_REQ_MAP;
    private static final Logger LOGGER;

    static {
        LAYOUT_REQ_MAP = (SetMultimap)NonNullUtils.checkNotNull((Object)HashMultimap.create());
        LAYOUT_REQUIREMENT = new KernelEventLayoutRequirement((Set<KernelEventLayoutRequirement.ILayoutToEventName>)ImmutableSet.of(l -> l.eventSchedSwitch()), TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
        LOGGER = TraceCompassLog.getLogger(KernelCpuUsageAnalysis.class);
    }

    private static IKernelAnalysisEventLayout getLayout(@Nullable ITmfTrace trace) {
        IKernelAnalysisEventLayout layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        return layout;
    }

    protected ITmfStateProvider createStateProvider() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        IKernelAnalysisEventLayout layout = KernelCpuUsageAnalysis.getLayout(trace);
        return new KernelCpuUsageStateProvider(trace, layout);
    }

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        HashSet<IAnalysisModule> modules = new HashSet<IAnalysisModule>();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalStateException("Analysis requires a trace");
        }
        Iterable kernelModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, TidAnalysisModule.class);
        Iterator iterator = kernelModules.iterator();
        if (iterator.hasNext()) {
            TidAnalysisModule kernelModule = (TidAnalysisModule)((Object)iterator.next());
            modules.add((IAnalysisModule)kernelModule);
        }
        return modules;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public int getNumberOfCores() {
        ITmfStateSystem cpuSs = this.getStateSystem();
        if (cpuSs != null) {
            try {
                int cpusNode = cpuSs.getQuarkAbsolute(new String[]{"CPUs"});
                @NonNull @NonNull List subAttributes = cpuSs.getSubAttributes(cpusNode, false);
                int cpus = Integer.MIN_VALUE;
                for (Integer quark : subAttributes) {
                    cpus = Math.max(Integer.parseInt(cpuSs.getAttributeName(quark.intValue())), cpus);
                }
                return Math.max(subAttributes.size(), cpus);
            }
            catch (AttributeNotFoundException e) {
                Activator.getDefault().logError("Error: getting number of core " + e.getMessage(), e);
            }
        }
        return -1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Map<String, Long> getCpuUsageInRange(Set<@NonNull Integer> cpus, long start, long end) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        HashMap<String, Long> totalMap = new HashMap<String, Long>();
        ITmfTrace trace = this.getTrace();
        ITmfStateSystem cpuSs = this.getStateSystem();
        if (trace == null || cpuSs == null) {
            return map;
        }
        ITmfStateSystem kernelSs = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)trace, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel.tid");
        if (kernelSs == null) {
            return map;
        }
        long startTime = Math.max(start, cpuSs.getStartTime());
        startTime = Math.max(startTime, kernelSs.getStartTime());
        long endTime = Math.min(end, cpuSs.getCurrentEndTime());
        endTime = Math.min(endTime, kernelSs.getCurrentEndTime());
        long totalTime = 0L;
        if (endTime < startTime) {
            return map;
        }
        try {
            Throwable throwable = null;
            Object var18_15 = null;
            try (TraceCompassLogUtils.ScopeLog scopeLog = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "KernelCpuUsageAnalysis#getCpuUsageInRange", new Object[0]);){
                int cpusNode = cpuSs.getQuarkAbsolute(new String[]{"CPUs"});
                HashMap<Integer, List> tidsPerCpu = new HashMap<Integer, List>();
                Iterator iterator = cpuSs.getSubAttributes(cpusNode, false).iterator();
                while (iterator.hasNext()) {
                    int cpuNode = (Integer)iterator.next();
                    @NonNull @NonNull List cpuSubAttributes = cpuSs.getSubAttributes(cpuNode, false);
                    if (!cpus.isEmpty() && !cpus.contains(Integer.parseInt(cpuSs.getAttributeName(cpuNode)))) continue;
                    tidsPerCpu.put(cpuNode, cpuSubAttributes);
                }
                List kernelEndState = kernelSs.queryFullState(endTime);
                List endState = cpuSs.queryFullState(endTime);
                List kernelStartState = kernelSs.queryFullState(startTime);
                List startState = cpuSs.queryFullState(startTime);
                int tidIdle = Integer.parseInt(TID_ZERO);
                for (Map.Entry entry : tidsPerCpu.entrySet()) {
                    int cpuNode = Objects.requireNonNull((Integer)entry.getKey());
                    List tidNodes = Objects.requireNonNull((List)entry.getValue());
                    String curCpuName = cpuSs.getAttributeName(cpuNode);
                    long cpuTotal = 0L;
                    int currentThreadQuark = kernelSs.getQuarkAbsolute(new String[]{curCpuName});
                    int startThread = ((ITmfStateInterval)kernelStartState.get(currentThreadQuark)).getStateValue().unboxInt();
                    int endThread = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getStateValue().unboxInt();
                    Iterator iterator2 = tidNodes.iterator();
                    while (iterator2.hasNext()) {
                        long currentCount;
                        int tidNode = (Integer)iterator2.next();
                        String curTidName = cpuSs.getAttributeName(tidNode);
                        int tid = Integer.parseInt(curTidName);
                        long countAtEnd = ((ITmfStateInterval)endState.get(tidNode)).getStateValue().unboxLong();
                        long countAtStart = ((ITmfStateInterval)startState.get(tidNode)).getStateValue().unboxLong();
                        if (countAtStart == -1L) {
                            countAtStart = 0L;
                        }
                        if (countAtEnd == -1L) {
                            countAtEnd = 0L;
                        }
                        if (tid == startThread || startThread == -1) {
                            ITmfStateInterval threadState = (ITmfStateInterval)kernelStartState.get(currentThreadQuark);
                            long runningTime = threadState.getEndTime() - threadState.getStartTime();
                            long runningEnd = threadState.getEndTime();
                            countAtStart = KernelCpuUsageAnalysis.interpolateCount(countAtStart, startTime, runningEnd, runningTime);
                        }
                        if (tid == endThread) {
                            long runningTime = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getEndTime() - ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getStartTime();
                            long runningEnd = ((ITmfStateInterval)kernelEndState.get(currentThreadQuark)).getEndTime();
                            countAtEnd = KernelCpuUsageAnalysis.interpolateCount(countAtEnd, endTime, runningEnd, runningTime);
                        }
                        if (startThread == -1 && (countAtEnd - countAtStart < 0L || countAtEnd == 0L)) {
                            countAtStart = 0L;
                        }
                        if ((currentCount = countAtEnd - countAtStart) < 0L) {
                            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"Negative count", (Object[])new Object[]{"CPU", curCpuName, "tid", curTidName, "startTime", startTime, "endTime", endTime, "countAtStart", countAtStart, "countAtEnd", countAtEnd});
                            currentCount = 0L;
                        } else if (currentCount > endTime - startTime) {
                            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINE, (String)"CPU usage over 100%", (Object[])new Object[]{"CPU", curCpuName, "tid", curTidName, "startTime", startTime, "CPU time", currentCount, "elapsed time", endTime - startTime, "usage", (double)currentCount * 100.0 / (double)(endTime - startTime)});
                            currentCount = 0L;
                        }
                        if (tid != tidIdle) {
                            cpuTotal += currentCount;
                        }
                        map.put(String.valueOf(curCpuName) + SPLIT_STRING + curTidName, currentCount);
                        KernelCpuUsageAnalysis.addToMap(totalMap, curTidName, currentCount);
                    }
                    map.put(curCpuName, cpuTotal);
                    totalTime += cpuTotal;
                }
                for (Map.Entry entry : totalMap.entrySet()) {
                    map.put("total/" + (String)entry.getKey(), (Long)entry.getValue());
                }
                map.put(TOTAL, totalTime);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AttributeNotFoundException | TimeRangeException throwable) {
        }
        catch (StateSystemDisposedException | StateValueTypeException e) {
            Activator.getDefault().logError("Error getting CPU usage in a time range", e);
        }
        return map;
    }

    private static long interpolateCount(long count, long ts, long runningEnd, long runningTime) {
        long newCount = count;
        if (runningTime > 0L) {
            long runningStart = runningEnd - runningTime;
            if (ts < runningStart) {
                return newCount;
            }
            newCount += ts - runningStart;
        }
        return newCount;
    }

    private static void addToMap(Map<String, Long> map, String key, Long value) {
        Long addTo = map.get(key);
        if (addTo == null) {
            map.put(key, value);
        } else {
            map.put(key, addTo + value);
        }
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        ITmfTrace trace = this.getTrace();
        IKernelAnalysisEventLayout layout = KernelCpuUsageAnalysis.getLayout(trace);
        Set reqs = LAYOUT_REQ_MAP.get((Object)layout);
        if (reqs.isEmpty()) {
            reqs = ImmutableSet.of((Object)LAYOUT_REQUIREMENT.instanciateRequirements(layout));
            LAYOUT_REQ_MAP.putAll((Object)layout, (Iterable)reqs);
        }
        return reqs;
    }
}

