/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Cost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFunctionCall;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalMemberAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;

public abstract class CPPEvaluation
implements ICPPEvaluation {
    CPPEvaluation() {
    }

    @Override
    public IBinding getTemplateDefinition() {
        return null;
    }

    @Override
    public char[] getSignature() {
        SignatureBuilder buf = new SignatureBuilder();
        try {
            this.marshal(buf, true);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{'?'};
        }
        return buf.getSignature();
    }

    public static IType getType(ICPPASTExpression expr) {
        CPPSemantics.pushLookupPoint(expr);
        try {
            IType iType = expr.getEvaluation().getType();
            return iType;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    public static IASTExpression.ValueCategory getValueCategory(ICPPASTExpression expr) {
        CPPSemantics.pushLookupPoint(expr);
        try {
            IASTExpression.ValueCategory valueCategory = expr.getEvaluation().getValueCategory();
            return valueCategory;
        }
        finally {
            CPPSemantics.popLookupPoint();
        }
    }

    protected static IBinding resolveUnknown(ICPPUnknownBinding unknown, InstantiationContext context) {
        try {
            return CPPTemplates.resolveUnknown(unknown, context);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return unknown;
        }
    }

    protected static ICPPTemplateArgument[] instantiateArguments(ICPPTemplateArgument[] args, InstantiationContext context, boolean strict) {
        try {
            return CPPTemplates.instantiateArguments(args, context, strict);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return args;
        }
    }

    protected static IBinding instantiateBinding(IBinding binding, InstantiationContext context, int maxDepth) {
        try {
            return CPPTemplates.instantiateBinding(binding, context, maxDepth);
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
            return binding;
        }
    }

    protected static boolean containsDependentType(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isTypeDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean containsDependentValue(ICPPEvaluation[] evaluations) {
        ICPPEvaluation[] iCPPEvaluationArray = evaluations;
        int n = evaluations.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation eval = iCPPEvaluationArray[n2];
            if (eval.isValueDependent()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean areAllConstantExpressions(ICPPEvaluation[] evaluations) {
        return CPPEvaluation.areAllConstantExpressions(evaluations, 0, evaluations.length);
    }

    protected static boolean areAllConstantExpressions(ICPPEvaluation[] evaluations, int from, int to) {
        int i = from;
        while (i < to) {
            if (!evaluations[i].isConstantExpression()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean isConstexprValue(IValue value) {
        if (value == null) {
            return false;
        }
        ICPPEvaluation innerEval = value.getEvaluation();
        if (innerEval == null) {
            if (value instanceof IntegralValue) {
                return value.numberValue() != null;
            }
            return true;
        }
        return innerEval.isConstantExpression();
    }

    protected static boolean isNullOrConstexprFunc(ICPPFunction function) {
        return function == null || function.isConstexpr();
    }

    protected static ICPPEvaluation maybeApplyConversion(ICPPEvaluation argument, IType targetType, boolean allowContextualConversion, boolean onlyConstexprConversion) {
        if (targetType == null) {
            return argument;
        }
        IType type = argument.getType();
        if (targetType.isSameType(type)) {
            return argument;
        }
        try {
            Cost cost;
            ICPPFunction conversion;
            IType uqType = SemanticUtil.getNestedType(type, 13);
            IASTExpression.ValueCategory valueCategory = argument.getValueCategory();
            if (uqType instanceof ICPPClassType && (conversion = (cost = Conversions.initializationByConversion(valueCategory, type, (ICPPClassType)uqType, targetType, false, allowContextualConversion)).getUserDefinedConversion()) != null) {
                if (onlyConstexprConversion && !conversion.isConstexpr()) {
                    return EvalFixed.INCOMPLETE;
                }
                EvalMemberAccess eval = new EvalMemberAccess(uqType, valueCategory, (IBinding)conversion, argument, false, CPPSemantics.getCurrentLookupPoint());
                return new EvalFunctionCall(new ICPPEvaluation[]{eval}, null, null);
            }
            if (!Conversions.checkImplicitConversionSequence(targetType, type, valueCategory, Conversions.UDCMode.FORBIDDEN, Conversions.Context.ORDINARY).converts()) {
                return EvalFixed.INCOMPLETE;
            }
        }
        catch (DOMException e) {
            CCorePlugin.log(e);
        }
        return argument;
    }

    protected static boolean areEquivalentOrNull(ICPPEvaluation a, ICPPEvaluation b) {
        if (a == null) {
            return b == null;
        }
        return a.isEquivalentTo(b);
    }

    protected static boolean areEquivalentEvaluations(ICPPEvaluation[] a, ICPPEvaluation[] b) {
        if (a == null) {
            return b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].isEquivalentTo(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean areEquivalentArguments(ICPPTemplateArgument[] a, ICPPTemplateArgument[] b) {
        if (a == null) {
            return b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].isSameValue(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static boolean areEquivalentTypes(IType[] a, IType[] b) {
        if (a == null) {
            return b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].isSameType(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static <T extends IBinding> boolean areEquivalentBindings(T[] a, T[] b) {
        if (a == null) {
            return b == null;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (!a[i].equals(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

