/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.commands.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.commands.common.NamedHandleObject;

public abstract class HandleObjectManager<T extends NamedHandleObject>
extends EventManager {
    protected final Set<T> definedHandleObjects = new HashSet<T>();
    protected final Map<String, T> handleObjectsById = new HashMap<String, T>();

    protected final void checkId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A handle object may not have a null identifier");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("The handle object must not have a zero-length identifier");
        }
    }

    protected final Set getDefinedHandleObjectIds() {
        HashSet<String> definedHandleObjectIds = new HashSet<String>(this.definedHandleObjects.size());
        for (HandleObject handleObject : this.definedHandleObjects) {
            String id = handleObject.getId();
            definedHandleObjectIds.add(id);
        }
        return definedHandleObjectIds;
    }
}

