/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header;

import java.util.Map;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFormatField;

public class BinaryFTraceEventFormat {
    private static final String COMMON_FIELD_PREFIX = "common_";
    private final int fEventFormatID;
    private final String fEventName;
    private final Map<String, BinaryFTraceFormatField> fCustomFields;
    private final Map<String, BinaryFTraceFormatField> fCommonFields;
    private final String fFormatString;

    public BinaryFTraceEventFormat(int eventFormatID, String eventName, Map<String, BinaryFTraceFormatField> commonFields, Map<String, BinaryFTraceFormatField> customFields, String formatString) {
        this.fEventFormatID = eventFormatID;
        this.fEventName = eventName;
        this.fCommonFields = commonFields;
        this.fCustomFields = customFields;
        this.fFormatString = formatString;
    }

    public int getEventFormatID() {
        return this.fEventFormatID;
    }

    public Map<String, BinaryFTraceFormatField> getCustomFields() {
        return this.fCustomFields;
    }

    public Map<String, BinaryFTraceFormatField> getCommonFields() {
        return this.fCommonFields;
    }

    public String getEventName() {
        return this.fEventName;
    }

    public String getFormatString() {
        return this.fFormatString;
    }

    public int getEventFormatSize() {
        int eventSize = 0;
        for (Map.Entry<String, BinaryFTraceFormatField> entry : this.fCommonFields.entrySet()) {
            eventSize += entry.getValue().getSize();
        }
        for (Map.Entry<String, BinaryFTraceFormatField> entry : this.fCustomFields.entrySet()) {
            eventSize += entry.getValue().getSize();
        }
        return eventSize;
    }

    public BinaryFTraceFormatField getFieldByName(String name) {
        if (name.startsWith(COMMON_FIELD_PREFIX) && this.fCommonFields.containsKey(name)) {
            return this.fCommonFields.get(name);
        }
        if (this.fCustomFields.containsKey(name)) {
            return this.fCustomFields.get(name);
        }
        return null;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Event name: ").append(this.fEventName).append('\n');
        strBuilder.append("Event ID: ").append(this.fEventFormatID).append('\n');
        strBuilder.append("Fields: ").append('\n');
        for (Map.Entry<String, BinaryFTraceFormatField> entry : this.fCommonFields.entrySet()) {
            strBuilder.append('\t').append(entry.getValue()).append('\n');
        }
        for (Map.Entry<String, BinaryFTraceFormatField> entry : this.fCustomFields.entrySet()) {
            strBuilder.append('\t').append(entry.getValue()).append('\n');
        }
        strBuilder.append("Format string: ").append(this.fFormatString);
        return strBuilder.toString();
    }
}

