/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

@Provider
public class RequestResponseLogger
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOGGER = TraceCompassLog.getLogger(RequestResponseLogger.class);
    private static final String REQUEST_ID_PROPERTY = "request-id";
    private static final String START_TIME_PROPERTY = "request-start-time";
    private static final String CLIENT_IP_PROPERTY = "client-ip";
    private static final String REQUEST_BODY_PROPERTY = "request-body";
    private static final String METHOD_PROPERTY = "http-method";
    private static final String PATH_PROPERTY = "http-path";
    private static final AtomicLong REQUEST_COUNTER = new AtomicLong(0L);
    private static final int MAX_BODY_LOG_LENGTH = 1000;
    private static final String HTTP_RESPONSE_KEY = "HTTP Response";
    private static final String HTTP_REQUEST_KEY = "HTTP Request";
    private static final String REQUEST_ID_KEY = "requestId";
    private static final String METHOD_KEY = "method";
    private static final String PATH_KEY = "path";
    private static final String CLIENT_IP_KEY = "clientIp";
    private static final String QUERY_PARAMS_KEY = "queryParams";
    private static final String HEADERS_KEY = "headers";
    private static final String STATUS_KEY = "status";
    private static final String BODY_KEY = "body";
    private static final String CONTENT_LENGTH_KEY = "contentLength";
    private static final String CONTENT_TYPE_KEY = "contentType";
    private static final String DURATION_KEY = "duration";
    @Context
    private HttpServletRequest httpRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        long requestTimestamp = System.currentTimeMillis();
        String method = requestContext.getMethod();
        String path = requestContext.getUriInfo().getPath();
        String clientIp = this.getClientIpAddress(requestContext);
        MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
        String requestId = RequestResponseLogger.generateRequestId(requestTimestamp, method, path, clientIp);
        requestContext.setProperty(REQUEST_ID_PROPERTY, (Object)requestId);
        requestContext.setProperty(CLIENT_IP_PROPERTY, (Object)clientIp);
        requestContext.setProperty(METHOD_PROPERTY, (Object)method);
        requestContext.setProperty(PATH_PROPERTY, (Object)path);
        requestContext.setProperty(START_TIME_PROPERTY, (Object)requestTimestamp);
        String bodyContent = "";
        if (method.matches("POST|PUT|PATCH|DELETE") && requestContext.hasEntity()) {
            String contentType;
            List contentTypeHeader = (List)requestContext.getHeaders().get((Object)"Content-Type");
            String string = contentType = contentTypeHeader != null && !contentTypeHeader.isEmpty() ? (String)contentTypeHeader.get(0) : "";
            if (contentType.matches(".*(application/json|application/x-www-form-urlencoded|text/).*")) {
                bodyContent = RequestResponseLogger.captureRequestBody(requestContext);
                bodyContent = bodyContent.length() > 1000 ? bodyContent.substring(0, 1000) + "..." : bodyContent;
                requestContext.setProperty(REQUEST_BODY_PROPERTY, (Object)bodyContent);
            }
        }
        String relevantHeaders = RequestResponseLogger.getRelevantRequestHeaders(requestContext);
        LogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)HTTP_REQUEST_KEY, (Object[])new Object[]{REQUEST_ID_KEY, requestId, METHOD_KEY, method, PATH_KEY, path, CLIENT_IP_KEY, clientIp, QUERY_PARAMS_KEY, queryParams.isEmpty() ? null : queryParams, HEADERS_KEY, relevantHeaders.isEmpty() ? null : relevantHeaders, BODY_KEY, bodyContent.isEmpty() ? null : bodyContent});
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (LOGGER.isLoggable(Level.INFO)) {
            String requestId = (String)requestContext.getProperty(REQUEST_ID_PROPERTY);
            String method = (String)requestContext.getProperty(METHOD_PROPERTY);
            String path = (String)requestContext.getProperty(PATH_PROPERTY);
            String clientIp = (String)requestContext.getProperty(CLIENT_IP_PROPERTY);
            int status = responseContext.getStatus();
            Long startTime = (Long)requestContext.getProperty(START_TIME_PROPERTY);
            long duration = startTime != null ? System.currentTimeMillis() - startTime : 0L;
            Object contentTypeObj = responseContext.getHeaders().getFirst((Object)"Content-Type");
            String contentType = contentTypeObj != null ? contentTypeObj.toString() : null;
            Object contentLengthObj = responseContext.getHeaders().getFirst((Object)"Content-Length");
            Long contentLength = contentLengthObj != null ? Long.valueOf(Long.parseLong(contentLengthObj.toString())) : null;
            LogUtils.traceInstant((Logger)LOGGER, (Level)Level.INFO, (String)HTTP_RESPONSE_KEY, (Object[])new Object[]{REQUEST_ID_KEY, requestId, METHOD_KEY, method, PATH_KEY, path, CLIENT_IP_KEY, clientIp, STATUS_KEY, status, DURATION_KEY, duration, CONTENT_TYPE_KEY, contentType, CONTENT_LENGTH_KEY, contentLength});
        }
    }

    private String getClientIpAddress(ContainerRequestContext requestContext) {
        String forwarded;
        String clientIp = null;
        String header = this.httpRequest.getHeader("X-Forwarded-For");
        if (header != null && !header.isEmpty()) {
            clientIp = header.split(",")[0].trim();
        }
        if (clientIp == null || clientIp.isEmpty()) {
            clientIp = this.httpRequest.getHeader("X-Real-IP");
        }
        if ((clientIp == null || clientIp.isEmpty()) && (forwarded = this.httpRequest.getHeader("Forwarded")) != null && forwarded.contains("for=")) {
            int start = forwarded.indexOf("for=") + 4;
            int end = forwarded.indexOf(";", start);
            clientIp = (end > 0 ? forwarded.substring(start, end) : forwarded.substring(start)).replace("\"", "").trim();
        }
        if (clientIp == null || clientIp.isEmpty()) {
            clientIp = this.httpRequest.getRemoteAddr();
        }
        if (clientIp == null || clientIp.isEmpty()) {
            return "unknown";
        }
        if (clientIp.startsWith("[") && clientIp.endsWith("]")) {
            clientIp = clientIp.substring(1, clientIp.length() - 1);
        }
        return clientIp;
    }

    private static String captureRequestBody(ContainerRequestContext requestContext) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            InputStream entityStream = requestContext.getEntityStream();
            byte[] buffer = new byte[1024];
            while ((len = entityStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] bytes = baos.toByteArray();
            requestContext.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getRelevantRequestHeaders(ContainerRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getHeaders();
        return headers.entrySet().stream().filter((? super T entry) -> {
            String headerName = ((String)entry.getKey()).toLowerCase();
            return headerName.startsWith("accept") || headerName.startsWith("content-") || headerName.equals("user-agent") || headerName.equals("host");
        }).map(entry -> (String)entry.getKey() + "=" + String.join((CharSequence)",", (Iterable)entry.getValue())).collect(Collectors.joining(", "));
    }

    private static String generateRequestId(long timestamp, String method, String path, String clientIp) {
        String uniqueId = String.format("%d-%s-%s-%s-%d", timestamp, method, path, clientIp, REQUEST_COUNTER.incrementAndGet());
        UUID uuid = UUID.nameUUIDFromBytes(uniqueId.getBytes(StandardCharsets.UTF_8));
        return uuid.toString();
    }
}

