/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;

public class LanguageSettingsDelta {
    private LinkedHashMap<String, LanguageSettingsStorage> oldLanguageSettingsState;
    private LinkedHashMap<String, LanguageSettingsStorage> newLanguageSettingsState;
    private Set<String> paths = null;

    public LanguageSettingsDelta(LinkedHashMap<String, LanguageSettingsStorage> oldState, LinkedHashMap<String, LanguageSettingsStorage> newState) {
        this.oldLanguageSettingsState = oldState;
        this.newLanguageSettingsState = newState;
    }

    public Set<String> getAffectedResourcePaths() {
        if (this.paths != null) {
            return this.paths;
        }
        this.paths = new TreeSet<String>();
        LanguageSettingsStorage oldCombinedStorage = this.combineStorage(this.oldLanguageSettingsState);
        LanguageSettingsStorage newCombinedStorage = this.combineStorage(this.newLanguageSettingsState);
        for (String lang : oldCombinedStorage.getLanguages()) {
            for (String path : oldCombinedStorage.getResourcePaths(lang)) {
                if (oldCombinedStorage.getSettingEntries(path, lang) == newCombinedStorage.getSettingEntries(path, lang)) continue;
                if (path == null) {
                    path = "";
                }
                this.paths.add(path);
            }
        }
        for (String lang : newCombinedStorage.getLanguages()) {
            for (String path : newCombinedStorage.getResourcePaths(lang)) {
                if (newCombinedStorage.getSettingEntries(path, lang) == oldCombinedStorage.getSettingEntries(path, lang)) continue;
                if (path == null) {
                    path = "";
                }
                this.paths.add(path);
            }
        }
        return this.paths;
    }

    private LanguageSettingsStorage combineStorage(LinkedHashMap<String, LanguageSettingsStorage> state) {
        LanguageSettingsStorage combinedStore = new LanguageSettingsStorage();
        for (LanguageSettingsStorage providerStore : state.values()) {
            for (String lang : providerStore.getLanguages()) {
                for (String path : providerStore.getResourcePaths(lang)) {
                    if (combinedStore.getSettingEntries(path, lang) != null) continue;
                    List<ICLanguageSettingEntry> entries = providerStore.getSettingEntries(path, lang);
                    combinedStore.setSettingEntries(path, lang, entries);
                }
            }
        }
        return combinedStore;
    }
}

