/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

@NonNullByDefault
public final class TmfTraceUtils {
    private static final int MAX_NB_BINARY_BYTES = 2048;
    private static final Set<ITmfEventAspect<?>> EXTRA_ASPECTS = new HashSet();

    private TmfTraceUtils() {
    }

    public static <T extends IAnalysisModule> @Nullable T getAnalysisModuleOfClass(ITmfTrace trace, Class<T> moduleClass, String id) {
        Iterable<IAnalysisModule> modules = TmfTraceUtils.getAnalysisModulesOfClass(trace, moduleClass);
        for (IAnalysisModule module : modules) {
            if (!id.equals(module.getId())) continue;
            return (T)module;
        }
        return null;
    }

    public static void registerEventAspect(ITmfEventAspect<?> aspect) {
        EXTRA_ASPECTS.add(aspect);
    }

    public static <T> Iterable<@NonNull T> getAnalysisModulesOfClass(ITmfTrace trace, Class<T> moduleClass) {
        Iterable<IAnalysisModule> analysisModules = trace.getAnalysisModules();
        ArrayList<@NonNull Object> modules = new ArrayList<Object>();
        for (IAnalysisModule module : analysisModules) {
            if (!moduleClass.isAssignableFrom(module.getClass())) continue;
            modules.add(NonNullUtils.checkNotNull(moduleClass.cast(module)));
        }
        for (ITmfEventProvider child : trace.getChildren()) {
            if (!(child instanceof ITmfTrace)) continue;
            ITmfTrace childTrace = (ITmfTrace)child;
            Iterables.addAll(modules, TmfTraceUtils.getAnalysisModulesOfClass(childTrace, moduleClass));
        }
        return modules;
    }

    public static <T> Iterable<@NonNull T> getAnalysisModulesOfClass(String hostId, Class<T> moduleClass) {
        Set<ITmfTrace> traces = TmfTraceManager.getInstance().getTracesForHost(hostId);
        ArrayList<@NonNull Object> modules = new ArrayList<Object>();
        for (ITmfTrace trace : traces) {
            Iterable<IAnalysisModule> analysisModules = trace.getAnalysisModules();
            for (IAnalysisModule module : analysisModules) {
                if (!moduleClass.isAssignableFrom(module.getClass())) continue;
                modules.add(NonNullUtils.checkNotNull(moduleClass.cast(module)));
            }
        }
        return modules;
    }

    public static Iterable<ITmfEventAspect<?>> getEventAspects(ITmfTrace trace, Class<? extends ITmfEventAspect<?>> aspectClass) {
        return Iterables.filter((Iterable)Iterables.concat(trace.getEventAspects(), EXTRA_ASPECTS), aspect -> aspectClass.isAssignableFrom(aspect.getClass()));
    }

    public static <T extends ITmfEventAspect<?>> @Nullable Object resolveEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Object value;
        for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || (value = aspect.resolve(event)) == null) continue;
            return value;
        }
        for (ITmfEventAspect<?> aspect : EXTRA_ASPECTS) {
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || (value = aspect.resolve(event)) == null) continue;
            return value;
        }
        return null;
    }

    public static @Nullable Object resolveAspectOfNameForEvent(ITmfTrace trace, String aspectName, ITmfEvent event) {
        Object value;
        for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
            if (!aspectName.equalsIgnoreCase(aspect.getName()) || (value = aspect.resolve(event)) == null) continue;
            return value;
        }
        for (ITmfEventAspect<?> aspect : EXTRA_ASPECTS) {
            if (!aspectName.equalsIgnoreCase(aspect.getName()) || (value = aspect.resolve(event)) == null) continue;
            return value;
        }
        return null;
    }

    public static <T extends ITmfEventAspect<Integer>> @Nullable Integer resolveIntEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Object value;
        for (ITmfEventAspect<?> aspect : trace.getEventAspects()) {
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || !((value = aspect.resolve(event)) instanceof Integer)) continue;
            return (Integer)value;
        }
        for (ITmfEventAspect<?> aspect : EXTRA_ASPECTS) {
            if (!aspectClass.isAssignableFrom(aspect.getClass()) || !((value = aspect.resolve(event)) instanceof Integer)) continue;
            return (Integer)value;
        }
        return null;
    }

    public static boolean isText(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            int count = 0;
            int val = bufferedInputStream.read();
            if (count < 2048 && val >= 0) {
            }
        }
        finally {
            Throwable throwable2;
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ITmfEvent getNextEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        EventMatchingRequest req = new EventMatchingRequest(startRank + 1L, predicate, false);
        trace.sendRequest(req);
        try {
            req.waitForStart();
            do {
                if (!req.isRunning()) {
                    req.waitForCompletion();
                    return req.getFoundEvent();
                }
                Thread.sleep(200L);
            } while (monitor == null || !monitor.isCanceled());
            req.cancel();
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ITmfEvent getPreviousEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        int step = trace.getCacheSize();
        if (startRank < (long)step) {
            step = (int)startRank;
        }
        long currentRank = startRank;
        try {
            ArrayFillingRequest req;
            block2: while (true) {
                if (currentRank <= 0L) {
                    return null;
                }
                currentRank = Math.max(currentRank - (long)step, 0L);
                ArrayList<ITmfEvent> list = new ArrayList<ITmfEvent>(step);
                req = new ArrayFillingRequest(currentRank, step, list);
                trace.sendRequest(req);
                req.waitForStart();
                do {
                    if (!req.isRunning()) {
                        req.waitForCompletion();
                        Optional<ITmfEvent> matchingEvent = Lists.reverse(list).stream().filter(predicate).findFirst();
                        if (!matchingEvent.isPresent()) continue block2;
                        return matchingEvent.get();
                    }
                    Thread.sleep(200L);
                } while (monitor == null || !monitor.isCanceled());
                break;
            }
            req.cancel();
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static class ArrayFillingRequest
    extends TmfEventRequest {
        private final List<ITmfEvent> fList;

        public ArrayFillingRequest(long startRank, int limit, List<ITmfEvent> listToFill) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fList = listToFill;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fList.add(event);
        }
    }

    private static class EventMatchingRequest
    extends TmfEventRequest {
        private final Predicate<ITmfEvent> fPredicate;
        private final boolean fReturnLast;
        private @Nullable ITmfEvent fFoundEvent = null;

        public EventMatchingRequest(long startRank, Predicate<ITmfEvent> predicate, boolean returnLast) {
            super(ITmfEvent.class, startRank, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fReturnLast = returnLast;
        }

        public EventMatchingRequest(long startRank, int limit, Predicate<ITmfEvent> predicate, boolean returnLast) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fReturnLast = returnLast;
        }

        public @Nullable ITmfEvent getFoundEvent() {
            return this.fFoundEvent;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (this.fPredicate.test(event)) {
                this.fFoundEvent = event;
                if (!this.fReturnLast) {
                    this.done();
                }
            }
        }
    }
}

