/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;

class CachingIterator
implements Iterator<ITimeEvent>,
Comparable<CachingIterator> {
    private ITimeEvent fEvent;
    private @NonNull Iterator<@NonNull ? extends ITimeEvent> fIterator;
    private final Comparator<ITimeEvent> fComparator;

    public CachingIterator(@NonNull Iterator<@NonNull ? extends ITimeEvent> iterator, Comparator<ITimeEvent> comparator) {
        this.fIterator = iterator;
        this.fComparator = comparator;
        this.fEvent = iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public ITimeEvent next() {
        ITimeEvent retVal = this.fEvent;
        ITimeEvent iTimeEvent = this.fEvent = this.fIterator.hasNext() ? this.fIterator.next() : null;
        if (retVal == null) {
            throw new NoSuchElementException("Iterator is empty");
        }
        return retVal;
    }

    @Override
    public boolean hasNext() {
        return this.fEvent != null;
    }

    public ITimeEvent peek() {
        return this.fEvent;
    }

    @Override
    public int compareTo(CachingIterator o) {
        ITimeEvent myEvent = this.peek();
        ITimeEvent otherEvent = o.peek();
        return this.fComparator.compare(myEvent, otherEvent);
    }

    public boolean trim(long time) {
        if (time <= this.fEvent.getTime()) {
            return false;
        }
        if (time < this.fEvent.getTime() + this.fEvent.getDuration()) {
            this.fEvent = this.fEvent.splitAfter(time);
            return true;
        }
        this.fEvent = this.fIterator.hasNext() ? this.fIterator.next() : null;
        return true;
    }
}

