/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.text.LengthAdjust;
import com.github.weisj.jsvg.nodes.text.Glyph;
import com.github.weisj.jsvg.nodes.text.TextMetrics;
import com.google.errorprone.annotations.Immutable;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;

@Immutable
final class GlyphAdvancement {
    private final float spacingAdjustment;
    private final float absoluteSpacingAdjustment;
    private final float glyphAdjustment;
    private final boolean needsLastSpacing;

    private GlyphAdvancement() {
        this.spacingAdjustment = 1.0f;
        this.absoluteSpacingAdjustment = 0.0f;
        this.glyphAdjustment = 1.0f;
        this.needsLastSpacing = false;
    }

    GlyphAdvancement(@NotNull TextMetrics textMetrics, float desiredLength, @NotNull LengthAdjust lengthAdjust) {
        double totalSpace = (double)desiredLength - textMetrics.fixedGlyphLength();
        switch (lengthAdjust) {
            default: {
                this.spacingAdjustment = 1.0f;
                this.glyphAdjustment = 1.0f;
                if (textMetrics.glyphCount() == 0) {
                    this.absoluteSpacingAdjustment = 0.0f;
                    this.needsLastSpacing = false;
                    break;
                }
                float adjustableSpace = (float)(totalSpace - textMetrics.glyphLength());
                int spacingCount = textMetrics.controllableLetterSpacingCount();
                if (spacingCount == 0) {
                    this.absoluteSpacingAdjustment = adjustableSpace;
                    this.needsLastSpacing = true;
                    break;
                }
                this.absoluteSpacingAdjustment = adjustableSpace / (float)spacingCount;
                this.needsLastSpacing = false;
                break;
            }
            case SpacingAndGlyphs: {
                this.absoluteSpacingAdjustment = 0.0f;
                this.needsLastSpacing = false;
                this.glyphAdjustment = this.spacingAdjustment = (float)(totalSpace / textMetrics.totalAdjustableLength());
            }
        }
    }

    static GlyphAdvancement defaultAdvancement() {
        return new GlyphAdvancement();
    }

    public float maxLookBehind() {
        return -Math.min(0.0f, this.absoluteSpacingAdjustment);
    }

    float spacingAdvancement(float letterSpacing) {
        return letterSpacing * this.spacingAdjustment + this.absoluteSpacingAdjustment;
    }

    float glyphAdvancement(@NotNull Glyph glyph) {
        return glyph.advance() * this.glyphAdjustment;
    }

    boolean shouldSkipLastSpacing() {
        if (this.needsLastSpacing) {
            return false;
        }
        return this.absoluteSpacingAdjustment != 0.0f || this.spacingAdjustment != 1.0f || this.glyphAdjustment != 1.0f;
    }

    @NotNull
    AffineTransform glyphTransform(@NotNull AffineTransform transform) {
        if (this.glyphAdjustment == 1.0f) {
            return transform;
        }
        AffineTransform glyphTransform = new AffineTransform(transform);
        glyphTransform.scale(this.glyphAdjustment, 1.0);
        return glyphTransform;
    }

    public String toString() {
        return "GlyphAdvancement{spacingAdjustment=" + this.spacingAdjustment + ", absoluteSpacingAdjustment=" + this.absoluteSpacingAdjustment + ", glyphAdjustment=" + this.glyphAdjustment + ", needsLastSpacing=" + this.needsLastSpacing + '}';
    }
}

