/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.ui.PlatformUI;

public class P2Module {
    @WrapToScript
    public void checkForUpdates() {
        IProvisioningAgent agent = (IProvisioningAgent)PlatformUI.getWorkbench().getService(IProvisioningAgent.class);
        ProvisioningSession session = new ProvisioningSession(agent);
        UpdateOperation operation = new UpdateOperation(session);
        IStatus status = operation.resolveModal(null);
        if (status.getCode() != 10000) {
            ProvisioningJob job;
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            if (status.getSeverity() != 4 && (status = (job = operation.getProvisioningJob(null)).runModal(null)).getSeverity() == 8) {
                throw new OperationCanceledException();
            }
        }
        if (status.getSeverity() == 4) {
            throw new RuntimeException(status.getMessage(), status.getException());
        }
    }

    @WrapToScript
    public void registerUpdateSite(String updateSite) throws ProvisionException, OperationCanceledException {
        URI location = URI.create(updateSite);
        IProvisioningAgent agent = (IProvisioningAgent)PlatformUI.getWorkbench().getService(IProvisioningAgent.class);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (metadataManager != null) {
            try {
                metadataManager.loadRepository(location, null);
            }
            catch (ProvisionException e) {
                String repositoryName = location + " - metadata";
                metadataManager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            }
        } else {
            throw new IllegalStateException("No metadata repository manager found");
        }
        IArtifactRepositoryManager artifactManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (artifactManager != null) {
            try {
                artifactManager.loadRepository(location, null);
            }
            catch (ProvisionException e) {
                String repositoryName = location + " - artifacts";
                artifactManager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            }
        } else {
            throw new IllegalStateException("No metadata repository manager found");
        }
    }

    @WrapToScript
    public void install(String component) {
        InstallOperation op;
        IStatus result;
        IProvisioningAgent agent = (IProvisioningAgent)PlatformUI.getWorkbench().getService(IProvisioningAgent.class);
        ProvisioningSession session = new ProvisioningSession(agent);
        HashSet installableUnits = new HashSet();
        IQuery query = QueryUtil.createIUQuery((String)component);
        query = QueryUtil.createLatestQuery((IQuery)query);
        IMetadataRepositoryManager metadataManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        IQueryResult queryResult = metadataManager.query(query, null);
        if (!queryResult.toSet().isEmpty() && (result = (op = new InstallOperation(session, (Collection)queryResult.toSet())).resolveModal(null)).isOK()) {
            op.getProvisioningJob(null).schedule();
        }
    }
}

