/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.StringTokenizer;

public class ValidatorActionFilter {
    public static final String ADD = "add";
    public static final String CHANGE = "change";
    public static final String DELETE = "delete";
    public static final int ALL_ACTIONS = 7;
    private int _actionType = 0;

    public int getActionType() {
        return this._actionType;
    }

    public void setActionTypes(String actions) {
        if (actions == null) {
            this._actionType = 7;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(actions, ",", false);
        boolean isAdd = false;
        int isChange = 0;
        int isDelete = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextAction = tokenizer.nextToken().trim();
            if (nextAction.equals(ADD)) {
                isAdd = true;
                continue;
            }
            if (nextAction.equals(CHANGE)) {
                isChange = 4;
                continue;
            }
            if (!nextAction.equals(DELETE)) continue;
            isDelete = 2;
        }
        this._actionType = isAdd | isChange | isDelete;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("     ActionFilter:");
        buffer.append("          add: " + ((this.getActionType() & 1) != 0 ? "on" : "off"));
        buffer.append("          change: " + ((this.getActionType() & 4) != 0 ? "on" : "off"));
        buffer.append("          delete: " + ((this.getActionType() & 2) != 0 ? "on" : "off"));
        return buffer.toString();
    }
}

