/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event.aspect;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;

public class MultiAspect<T>
implements ITmfEventAspect<T> {
    private static final Logger LOGGER = TraceCompassLog.getLogger(MultiAspect.class);
    private final String fName;
    private final Iterable<ITmfEventAspect<?>> fAspects;

    public static @Nullable ITmfEventAspect<?> create(Iterable<ITmfEventAspect<?>> aspects, Class<?> aspectClass) {
        int size = Iterables.size(aspects);
        if (size == 0 || size == 1) {
            return (ITmfEventAspect)Iterables.getFirst(aspects, null);
        }
        HashSet<String> names = new HashSet<String>();
        for (ITmfEventAspect<?> aspect : aspects) {
            if (aspectClass.isAssignableFrom(aspect.getClass())) {
                names.add(aspect.getName());
                continue;
            }
            throw new IllegalArgumentException("Aspects must belong to the same class as the \"aspectClass\" parameter.");
        }
        if (names.size() != 1) {
            StringJoiner sj = new StringJoiner(", ");
            names.forEach(sj::add);
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.WARNING, (String)"Aspects do not have the same name: ", (Object[])new Object[]{sj.toString()});
        }
        return new MultiAspect((String)Iterables.get(names, (int)0), aspects);
    }

    private MultiAspect(String name, Iterable<ITmfEventAspect<?>> aspects) {
        this.fName = name;
        this.fAspects = aspects;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getHelpText() {
        return ((ITmfEventAspect)Iterables.get(this.fAspects, (int)0)).getHelpText();
    }

    @Override
    public @Nullable T resolve(ITmfEvent event) {
        for (ITmfEventAspect<?> aspect : this.fAspects) {
            Object resolve = aspect.resolve(event);
            if (resolve == null) continue;
            return (T)resolve;
        }
        return null;
    }
}

