/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.ui.views.vresources.Processor;

@NonNullByDefault
public class Machine {
    private final String fMachineName;
    private final String fHostId;
    private @Nullable Machine fHost = null;
    private Set<Processor> fCpus = new HashSet<Processor>();
    private Set<Processor> fPcpus = new HashSet<Processor>();
    private Set<Machine> fContainers = new HashSet<Machine>();
    private Set<Machine> fVirtualMachines = new HashSet<Machine>();
    private int fMachineType;

    public Machine(String name, String hostId, int type) {
        this(name, hostId, type, Collections.emptyList());
    }

    public Machine(String name, String hostId, int type, Collection<String> pcpus) {
        this.fMachineName = name;
        this.fMachineType = type;
        this.fHostId = hostId;
        for (String pcpu : pcpus) {
            this.fPcpus.add(new Processor(pcpu, this));
        }
    }

    public Machine createContainer(String name, String hostId, List<String> physCpus) {
        Machine container = new Machine(name, hostId, 4, physCpus);
        container.setHost(this);
        this.fContainers.add(container);
        return container;
    }

    public boolean isContainer() {
        return this.fMachineType == 4;
    }

    public String getMachineName() {
        return this.fMachineName;
    }

    public String getHostId() {
        return this.fHostId;
    }

    public void setHost(Machine host) {
        this.fHost = host;
    }

    public @Nullable Machine getHost() {
        return this.fHost;
    }

    public Collection<Machine> getContainers() {
        return this.fContainers;
    }

    public Collection<Machine> getVirtualMachines() {
        return this.fVirtualMachines;
    }

    public void addCpu(String cpu) {
        this.fCpus.add(new Processor(cpu, this));
    }

    public void addPCpu(String pcpu) {
        this.fPcpus.add(new Processor(pcpu, this));
    }

    public void addVirtualMachine(Machine machine) {
        if ((machine.fMachineType & 2) != 2) {
            return;
        }
        this.fVirtualMachines.add(machine);
    }

    public Collection<Processor> getCpus() {
        return this.fCpus;
    }

    public Collection<Processor> getPhysicalCpus() {
        return this.fPcpus;
    }

    public String toString() {
        return String.valueOf(this.fMachineName) + (this.fHost != null ? " in " + this.fHost : "");
    }
}

