/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;

class SuppressDocWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final Map<String, DiagnosticGroupWarningsGuard> suppressors = new HashMap<String, DiagnosticGroupWarningsGuard>();

    SuppressDocWarningsGuard(Map<String, DiagnosticGroup> suppressibleGroups) {
        for (Map.Entry<String, DiagnosticGroup> entry : suppressibleGroups.entrySet()) {
            this.suppressors.put(entry.getKey(), new DiagnosticGroupWarningsGuard(entry.getValue(), CheckLevel.OFF));
        }
    }

    @Override
    public CheckLevel level(JSError error) {
        Node node = error.node;
        if (node != null) {
            boolean visitedFunction = false;
            for (Node current = node; current != null; current = current.getParent()) {
                Node rhs;
                int type = current.getType();
                JSDocInfo info = null;
                if (type == 105) {
                    info = NodeUtil.getBestJSDocInfo(current);
                    visitedFunction = true;
                } else if (type == 132) {
                    info = current.getJSDocInfo();
                } else if ((current.isVar() || current.isAssign()) && (rhs = NodeUtil.getRValueOfLValue(current.getFirstChild())) != null) {
                    if (rhs.isCast()) {
                        rhs = rhs.getFirstChild();
                    }
                    if (rhs.isFunction() && !visitedFunction) {
                        info = NodeUtil.getBestJSDocInfo(current);
                    }
                }
                if (info == null) continue;
                for (String suppressor : info.getSuppressions()) {
                    CheckLevel newLevel;
                    WarningsGuard guard = this.suppressors.get(suppressor);
                    if (guard == null || (newLevel = guard.level(error)) == null) continue;
                    return newLevel;
                }
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_DOC.value;
    }
}

