/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.event;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class OpenTracingField {
    private final String fOperationName;
    private final ITmfEventField fContent;
    private final String fSpanId;
    private final Long fStartTime;
    private final Long fDuration;
    private final @Nullable Map<String, Object> fTags;
    private final @Nullable Map<String, Object> fProcessTags;
    private String fProcessName;
    private static final Gson G_SON = new Gson();

    public static @Nullable String getProcess(String eventString) {
        @Nullable JsonObject root = (JsonObject)G_SON.fromJson(eventString, JsonObject.class);
        String process = OpenTracingField.optString(root, "processID");
        return process == null ? "" : process;
    }

    public static @Nullable OpenTracingField parseJson(String fieldsString, @Nullable String processField) {
        JsonArray logs;
        JsonArray tags;
        Long duration;
        @Nullable JsonObject root = (JsonObject)G_SON.fromJson(fieldsString, JsonObject.class);
        String name = String.valueOf(OpenTracingField.optString(root, "operationName"));
        if (name == "null") {
            return null;
        }
        String traceId = OpenTracingField.optString(root, "traceID");
        String spanId = OpenTracingField.optString(root, "spanID");
        Integer flags = OpenTracingField.optInt(root, "flags");
        Long startTime = OpenTracingField.optLong(root, "startTime");
        if (Double.isFinite(startTime.longValue())) {
            startTime = TmfTimestamp.fromMicros((long)startTime).toNanos();
        }
        if (Double.isFinite((duration = Long.valueOf(OpenTracingField.optLong(root, "duration"))).longValue())) {
            duration = TmfTimestamp.fromMicros((long)duration).toNanos();
        }
        HashMap<@NonNull String, @NonNull Object> fieldsMap = new HashMap<String, Object>();
        JsonArray refs = OpenTracingField.optJSONArray(root, "references");
        if (refs != null) {
            int i = 0;
            while (i < refs.size()) {
                String key = Objects.requireNonNull(refs.get(i).getAsJsonObject().get("refType").getAsString());
                JsonElement element = Objects.requireNonNull(refs.get(i).getAsJsonObject().get("spanID"));
                String value = String.valueOf(element.isJsonPrimitive() ? element.getAsJsonPrimitive().getAsString() : element.toString());
                fieldsMap.put("references/" + key, value);
                ++i;
            }
        }
        if ((tags = OpenTracingField.optJSONArray(root, "tags")) != null) {
            int i = 0;
            while (i < tags.size()) {
                String key = Objects.requireNonNull(tags.get(i).getAsJsonObject().get("key").getAsString());
                JsonElement element = Objects.requireNonNull(tags.get(i).getAsJsonObject().get("value"));
                String value = String.valueOf(element.isJsonPrimitive() ? element.getAsJsonPrimitive().getAsString() : element.toString());
                fieldsMap.put("tags/" + key, value);
                ++i;
            }
        }
        if ((logs = OpenTracingField.optJSONArray(root, "logs")) != null) {
            HashMap timestampList = new HashMap();
            int i = 0;
            while (i < logs.size()) {
                Long timestamp = OpenTracingField.optLong(logs.get(i).getAsJsonObject(), "timestamp");
                if (Double.isFinite(timestamp.longValue())) {
                    timestamp = TmfTimestamp.fromMicros((long)timestamp).toNanos();
                }
                JsonArray fields = Objects.requireNonNull(logs.get(i).getAsJsonObject().get("fields").getAsJsonArray());
                HashMap<String, String> fieldsList = new HashMap<String, String>();
                int j = 0;
                while (j < fields.size()) {
                    String key = Objects.requireNonNull(fields.get(j).getAsJsonObject().get("key").getAsString());
                    JsonElement element = Objects.requireNonNull(fields.get(j).getAsJsonObject().get("value"));
                    String value = String.valueOf(element.isJsonPrimitive() ? element.getAsJsonPrimitive().getAsString() : element.toString());
                    fieldsList.put(key, value);
                    ++j;
                }
                timestampList.put(timestamp, fieldsList);
                ++i;
            }
            fieldsMap.put("logs", timestampList);
        }
        if (traceId == null || spanId == null) {
            return null;
        }
        fieldsMap.put("operationName", name);
        fieldsMap.put("traceID", traceId);
        fieldsMap.put("spanID", spanId);
        if (flags != Integer.MIN_VALUE) {
            fieldsMap.put("flags", flags);
        }
        fieldsMap.put("startTime", startTime);
        fieldsMap.put("duration", duration);
        String processName = processField == null ? "" : OpenTracingField.parseProcess(processField, fieldsMap);
        fieldsMap.put("processName", processName);
        return new OpenTracingField(name, fieldsMap, spanId, startTime, duration, processName);
    }

    public static String parseProcess(String processField, Map<String, Object> fieldsMap) {
        @Nullable JsonObject root = (JsonObject)G_SON.fromJson(processField, JsonObject.class);
        String name = String.valueOf(OpenTracingField.optString(root, "serviceName"));
        if (name == "null") {
            return "";
        }
        JsonArray tags = OpenTracingField.optJSONArray(root, "tags");
        if (tags != null) {
            int i = 0;
            while (i < tags.size()) {
                String key = Objects.requireNonNull(tags.get(i).getAsJsonObject().get("key").getAsString());
                JsonElement element = Objects.requireNonNull(tags.get(i).getAsJsonObject().get("value"));
                String value = String.valueOf(element.isJsonPrimitive() ? element.getAsJsonPrimitive().getAsString() : element.toString());
                fieldsMap.put("processTags/" + key, value);
                ++i;
            }
        }
        return name;
    }

    private static long optLong(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsLong() : Long.MIN_VALUE;
    }

    private static int optInt(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsInt() : Integer.MIN_VALUE;
    }

    private static @Nullable JsonArray optJSONArray(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsJsonArray() : null;
    }

    private static @Nullable String optString(JsonObject root, String key) {
        JsonElement jsonElement = root.get(key);
        return jsonElement != null ? jsonElement.getAsString() : null;
    }

    private OpenTracingField(String name, Map<String, Object> fields, String spanId, Long startTime, Long duration, String processName) {
        this.fOperationName = name;
        ITmfEventField[] array = (ITmfEventField[])fields.entrySet().stream().map(entry -> new TmfEventField((String)entry.getKey(), entry.getValue(), null)).toArray(ITmfEventField[]::new);
        this.fContent = new TmfEventField(":root:", fields, array);
        this.fSpanId = spanId;
        this.fStartTime = startTime;
        this.fDuration = duration;
        Map<@NonNull String, @NonNull Object> tags = fields.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("tags/")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(5), Map.Entry::getValue));
        this.fTags = tags.isEmpty() ? null : tags;
        Map<@NonNull String, @NonNull Object> processTags = fields.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("processTags/")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(12), Map.Entry::getValue));
        this.fProcessTags = processTags.isEmpty() ? null : processTags;
        this.fProcessName = processName;
    }

    public String getName() {
        return this.fOperationName;
    }

    public ITmfEventField getContent() {
        return this.fContent;
    }

    public String getSpanId() {
        return this.fSpanId;
    }

    public Long getStartTime() {
        return this.fStartTime;
    }

    public Long getDuration() {
        return this.fDuration;
    }

    public @Nullable Map<String, Object> getTags() {
        return this.fTags;
    }

    public @Nullable Map<String, Object> getProcessTags() {
        return this.fProcessTags;
    }

    public String getProcessName() {
        return this.fProcessName;
    }
}

