/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateValueCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenMappingGroup;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlMappingGroupCu
implements IDataDrivenCompilationUnit {
    private final String fId;
    private final List<TmfXmlMappingEntryCu> fEntries;

    TmfXmlMappingGroupCu(String id, List<TmfXmlMappingEntryCu> entries) {
        this.fEntries = entries;
        this.fId = id;
    }

    @Override
    public DataDrivenMappingGroup generate() {
        List<DataDrivenMappingGroup.DataDrivenMappingEntry> collect = this.fEntries.stream().map(TmfXmlMappingEntryCu::generate).collect(Collectors.toList());
        DataDrivenMappingGroup mapGroup = new DataDrivenMappingGroup(this.fId, collect);
        return mapGroup;
    }

    public String getId() {
        return this.fId;
    }

    public static @Nullable TmfXmlMappingGroupCu compile(AnalysisCompilationData analysisData, Element mapGroupEl) {
        String id = mapGroupEl.getAttribute("id");
        List<Element> entries = TmfXmlUtils.getChildElements(mapGroupEl, "entry");
        ArrayList<TmfXmlMappingEntryCu> entriesCu = new ArrayList<TmfXmlMappingEntryCu>();
        for (Element entryElement : entries) {
            List<Element> svElements = TmfXmlUtils.getChildElements(entryElement, "stateValue");
            if (svElements.size() != 2) {
                Activator.logError("TmfXmlMappingGroupCu: There should be 2 children state values. There were " + svElements.size());
                return null;
            }
            TmfXmlStateValueCu keySv = TmfXmlStateValueCu.compileValue(analysisData, svElements.get(0));
            if (keySv == null) {
                Activator.logError("TmfXmlMappingGroupCu: Invalid key");
                return null;
            }
            TmfXmlStateValueCu valueSv = TmfXmlStateValueCu.compileValue(analysisData, svElements.get(1));
            if (valueSv == null) {
                Activator.logError("TmfXmlMappingGroupCu: Invalid value");
                return null;
            }
            TmfXmlMappingEntryCu mapEntry = new TmfXmlMappingEntryCu(keySv, valueSv);
            entriesCu.add(mapEntry);
        }
        TmfXmlMappingGroupCu mappingGroup = new TmfXmlMappingGroupCu(id, entriesCu);
        analysisData.addMappingGroup(id, mappingGroup);
        return mappingGroup;
    }

    private static class TmfXmlMappingEntryCu {
        private final TmfXmlStateValueCu fKey;
        private final TmfXmlStateValueCu fVal;

        public TmfXmlMappingEntryCu(TmfXmlStateValueCu key, TmfXmlStateValueCu val) {
            this.fKey = key;
            this.fVal = val;
        }

        public DataDrivenMappingGroup.DataDrivenMappingEntry generate() {
            return new DataDrivenMappingGroup.DataDrivenMappingEntry(this.fKey.generate(), this.fVal.generate());
        }
    }
}

