/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.segmentstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisModule;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.segment.ISegmentAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class SegmentStoreAnalysisModule
extends AbstractSegmentStoreAnalysisModule {
    private static final Logger LOGGER = TraceCompassLog.getLogger(SegmentStoreAnalysisModule.class);
    private static final Map<ISegmentAspect, ISegmentAspect> fAspects = new HashMap<ISegmentAspect, ISegmentAspect>();
    private Map<String, ISegmentStoreProvider> fProviders = new HashMap<String, ISegmentStoreProvider>();
    private @Nullable String fName;

    @VisibleForTesting
    public SegmentStoreAnalysisModule(ITmfTrace trace) throws TmfAnalysisException {
        this.setTrace(trace);
        if (trace instanceof TmfExperiment) {
            for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                IAnalysisModule m = (IAnalysisModule)tr.getAnalysisModules().iterator().next();
                this.addAnalysis(m, String.valueOf(tr.getName()));
            }
        } else {
            IAnalysisModule m = (IAnalysisModule)trace.getAnalysisModules().iterator().next();
            this.addAnalysis(m, String.valueOf(trace.getName()));
        }
    }

    public SegmentStoreAnalysisModule(ITmfTrace trace, String id) {
        if (trace instanceof TmfExperiment) {
            for (ITmfTrace tr : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                IAnalysisModule m = tr.getAnalysisModule(id);
                if (m == null) continue;
                this.addAnalysis(m, String.valueOf(tr.getName()));
            }
        } else {
            IAnalysisModule m = trace.getAnalysisModule(id);
            if (m != null) {
                this.addAnalysis(m, String.valueOf(trace.getName()));
            }
        }
    }

    private void addAnalysis(IAnalysisModule module, String traceName) {
        if (module instanceof ISegmentStoreProvider) {
            this.fName = module.getName();
            module.schedule();
            this.fProviders.putIfAbsent(traceName, (ISegmentStoreProvider)module);
        }
    }

    public String getName() {
        return NonNullUtils.nullToEmptyString((Object)this.fName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean buildAnalysisSegments(ISegmentStore<ISegment> segmentStore, IProgressMonitor monitor) throws TmfAnalysisException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (LogUtils.ScopeLog scope = new LogUtils.ScopeLog(LOGGER, Level.FINER, "SegmentStoreAnalysisModule#buildAnalysisSegment", new Object[0]);){
            int size = this.fProviders.size();
            if (size == 0) {
                return false;
            }
            if (size == 1) {
                segmentStore.addAll(Objects.requireNonNull(this.fProviders.get(this.fProviders.keySet().iterator().next())).getSegmentStore());
                return true;
            }
            for (Map.Entry<String, ISegmentStoreProvider> providerEntry : this.fProviders.entrySet()) {
                ISegmentStore<ISegment> segments = Objects.requireNonNull(providerEntry.getValue()).getSegmentStore();
                if (segments == null) continue;
                for (ISegment segment : segments) {
                    segmentStore.add((Object)new TraceNameSegment(providerEntry.getKey(), segment));
                }
            }
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    @Override
    public void dispose() {
        for (Map.Entry<String, ISegmentStoreProvider> providerEntry : this.fProviders.entrySet()) {
            ISegmentStoreProvider provider = Objects.requireNonNull(providerEntry.getValue());
            if (!(provider instanceof IAnalysisModule)) continue;
            ((IAnalysisModule)provider).dispose();
        }
        super.dispose();
    }

    protected void canceling() {
    }

    @Override
    public Iterable<ISegmentAspect> getSegmentAspects() {
        if (this.fProviders.size() > 1) {
            return this.getExperimentSegmentAspects();
        }
        if (this.fProviders.size() == 1) {
            ISegmentStoreProvider provider = this.fProviders.values().iterator().next();
            return provider.getSegmentAspects();
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        for (Map.Entry<String, ISegmentStoreProvider> providerEntry : this.fProviders.entrySet()) {
            ISegmentStoreProvider provider = Objects.requireNonNull(providerEntry.getValue());
            if (!(provider instanceof IAnalysisModule)) continue;
            ((IAnalysisModule)provider).waitForCompletion(monitor);
        }
        return super.executeAnalysis(monitor);
    }

    private Iterable<ISegmentAspect> getExperimentSegmentAspects() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        ISegmentStoreProvider provider = this.fProviders.get(this.fProviders.keySet().iterator().next());
        if (provider != null) {
            builder.addAll(SegmentStoreAnalysisModule.getWrapperAspects(provider.getSegmentAspects()));
        }
        builder.add((Object)SegmentAspectTraceName.INSTANCE);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ISegmentAspect> getWrapperAspects(Iterable<ISegmentAspect> aspects) {
        ArrayList<ISegmentAspect> wrappedAspects = new ArrayList<ISegmentAspect>();
        for (ISegmentAspect aspect : aspects) {
            Map<ISegmentAspect, ISegmentAspect> map = fAspects;
            synchronized (map) {
                ISegmentAspect wrapperAspect = fAspects.computeIfAbsent(aspect, a -> new SegmentAspectWrapper(aspect));
                wrappedAspects.add(wrapperAspect);
            }
        }
        return wrappedAspects;
    }

    private static class SegmentAspectTraceName
    implements ISegmentAspect {
        public static final ISegmentAspect INSTANCE = new SegmentAspectTraceName();

        private SegmentAspectTraceName() {
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof TraceNameSegment) {
                return ((TraceNameSegment)segment).getTraceName();
            }
            return null;
        }

        public String getName() {
            return "Trace";
        }

        public String getHelpText() {
            return "";
        }

        public @Nullable Comparator<?> getComparator() {
            return Comparator.comparing(TraceNameSegment::getTraceName);
        }
    }

    private static class SegmentAspectWrapper
    implements ISegmentAspect {
        private ISegmentAspect fAspect;

        public SegmentAspectWrapper(ISegmentAspect aspect) {
            this.fAspect = aspect;
        }

        public String getName() {
            return this.fAspect.getName();
        }

        public String getHelpText() {
            return this.fAspect.getHelpText();
        }

        public @Nullable Comparator<?> getComparator() {
            return this.fAspect.getComparator();
        }

        public @Nullable Object resolve(ISegment segment) {
            if (segment instanceof TraceNameSegment) {
                return this.fAspect.resolve(((TraceNameSegment)segment).getSegment());
            }
            return this.fAspect.resolve(segment);
        }
    }

    private static class TraceNameSegment
    implements ISegment {
        private static final long serialVersionUID = 5122084433695846745L;
        private String fTraceName;
        private ISegment fSegment;

        public TraceNameSegment(String traceName, ISegment segment) {
            this.fSegment = segment;
            this.fTraceName = traceName;
        }

        public String getTraceName() {
            return this.fTraceName;
        }

        public long getStart() {
            return this.fSegment.getStart();
        }

        public long getEnd() {
            return this.fSegment.getEnd();
        }

        public ISegment getSegment() {
            return this.fSegment;
        }
    }
}

