/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class CPPASTTypeId
extends ASTNode
implements ICPPASTTypeId {
    private IASTDeclSpecifier declSpec;
    private IASTDeclarator absDecl;
    private boolean isPackExpansion;

    public CPPASTTypeId() {
    }

    public CPPASTTypeId(IASTDeclSpecifier declSpec, IASTDeclarator absDecl) {
        this.setDeclSpecifier(declSpec);
        this.setAbstractDeclarator(absDecl);
    }

    @Override
    public CPPASTTypeId copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTTypeId copy(IASTNode.CopyStyle style) {
        CPPASTTypeId copy = new CPPASTTypeId();
        copy.setDeclSpecifier(this.declSpec == null ? null : this.declSpec.copy(style));
        copy.setAbstractDeclarator(this.absDecl == null ? null : this.absDecl.copy(style));
        copy.isPackExpansion = this.isPackExpansion;
        return this.copy(copy, style);
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpec;
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    @Override
    public IASTDeclarator getAbstractDeclarator() {
        return this.absDecl;
    }

    @Override
    public void setAbstractDeclarator(IASTDeclarator abstractDeclarator) {
        this.assertNotFrozen();
        this.absDecl = abstractDeclarator;
        if (abstractDeclarator != null) {
            abstractDeclarator.setParent(this);
            abstractDeclarator.setPropertyInParent(ABSTRACT_DECLARATOR);
        }
    }

    @Override
    public boolean isPackExpansion() {
        return this.isPackExpansion;
    }

    @Override
    public void setIsPackExpansion(boolean val) {
        this.isPackExpansion = val;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitTypeIds) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpec != null && !this.declSpec.accept(action)) {
            return false;
        }
        if (this.absDecl != null && !this.absDecl.accept(action)) {
            return false;
        }
        if (action.shouldVisitTypeIds) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }
}

