/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPMemberBlock {
    private static final int MAX_MEMBER_COUNT = 6;
    private static final int VISIBILITY_BITS = 2;
    private static final int VISIBILITY_MASK = 3;
    private static final int VISIBILITY_VALUES_PER_BYTE = 4;
    private static final int MEMBER_POINTERS = 0;
    private static final int MEMBER_VISIBILITIES = 24;
    private static final int NEXT_MEMBER_BLOCK = 26;
    protected static final int RECORD_SIZE = 30;
    private final PDOMLinkage linkage;
    private final long record;
    private int nextMemberPosition;

    public PDOMCPPMemberBlock(PDOMLinkage linkage, long record) throws CoreException {
        this.linkage = linkage;
        this.record = record;
        this.nextMemberPosition = -1;
    }

    public PDOMCPPMemberBlock(PDOMLinkage linkage) throws CoreException {
        Database db = linkage.getDB();
        this.linkage = linkage;
        this.record = db.malloc(30);
    }

    private int getNextPosition() throws CoreException {
        if (this.nextMemberPosition < 0) {
            this.nextMemberPosition = 0;
            while (this.nextMemberPosition < 6 && this.getMemberRecord(this.nextMemberPosition) != 0L) {
                ++this.nextMemberPosition;
            }
        }
        return this.nextMemberPosition;
    }

    private Database getDB() {
        return this.linkage.getDB();
    }

    private PDOM getPDOM() {
        return this.linkage.getPDOM();
    }

    public long getRecord() {
        return this.record;
    }

    public void setNextBlock(PDOMCPPMemberBlock nextBlock) throws CoreException {
        long rec = nextBlock != null ? nextBlock.getRecord() : 0L;
        this.getDB().putRecPtr(this.record + 26L, rec);
    }

    public PDOMCPPMemberBlock getNextBlock() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 26L);
        return rec != 0L ? new PDOMCPPMemberBlock(this.linkage, rec) : null;
    }

    public void addMember(PDOMNode member, int visibility) throws CoreException {
        PDOMCPPMemberBlock.addMember(this, member, visibility);
    }

    private static void addMember(PDOMCPPMemberBlock block, PDOMNode member, int visibility) throws CoreException {
        assert (member.getPDOM() == block.getPDOM());
        while (true) {
            int pos;
            if ((pos = block.getNextPosition()) < 6) {
                long memberLocationOffset = block.getMemberOffset(pos);
                block.getDB().putRecPtr(memberLocationOffset, member.getRecord());
                block.setVisibility(pos, visibility);
                ++block.nextMemberPosition;
                break;
            }
            PDOMCPPMemberBlock previousBlock = block;
            if ((block = block.getNextBlock()) != null) continue;
            block = new PDOMCPPMemberBlock(previousBlock.linkage);
            previousBlock.setNextBlock(block);
        }
    }

    public void accept(IPDOMVisitor visitor) throws CoreException {
        PDOMCPPMemberBlock current = this;
        do {
            current.visitBlock(visitor);
        } while ((current = current.getNextBlock()) != null);
    }

    private void visitBlock(IPDOMVisitor visitor) throws CoreException {
        long memberRecord;
        if (this.record == 0L) {
            throw new NullPointerException();
        }
        int item = 0;
        while (item < 6 && (memberRecord = this.getMemberRecord(item++)) != 0L) {
            PDOMNode node = PDOMNode.load(this.getPDOM(), memberRecord);
            if (node == null) continue;
            if (visitor.visit(node)) {
                node.accept(visitor);
            }
            visitor.leave(node);
        }
    }

    public void delete() throws CoreException {
        this.getDB().free(this.record);
    }

    private long getMemberRecord(int memberIndex) throws CoreException {
        return this.getDB().getRecPtr(this.getMemberOffset(memberIndex));
    }

    private long getMemberOffset(int memberIndex) {
        return this.record + 0L + (long)(4 * memberIndex);
    }

    private void setVisibility(int memberIndex, int newVisibility) throws CoreException {
        int visibilityBitOffset = memberIndex % 4;
        long visibilityOffset = this.record + 24L + (long)(memberIndex / 4);
        int visibility = this.getDB().getByte(visibilityOffset);
        visibility &= ~(3 << visibilityBitOffset * 2);
        this.getDB().putByte(visibilityOffset, (byte)(visibility |= (newVisibility &= 3) << visibilityBitOffset * 2));
    }

    public int getVisibility(IBinding member) throws CoreException {
        IIndexFragmentBinding indexMember = this.getPDOM().adaptBinding(member);
        if (!(indexMember instanceof PDOMNode)) {
            return -1;
        }
        return PDOMCPPMemberBlock.getVisibility(this, (PDOMNode)((Object)indexMember));
    }

    private static int getVisibility(PDOMCPPMemberBlock block, PDOMNode memberNode) throws CoreException {
        long memberRecord = memberNode.getRecord();
        do {
            int memberIndex = 0;
            while (memberIndex < 6) {
                long rec = block.getMemberRecord(memberIndex);
                if (rec == 0L) {
                    return -1;
                }
                if (rec == memberRecord) {
                    return block.getVisibility(memberIndex);
                }
                ++memberIndex;
            }
        } while ((block = block.getNextBlock()) != null);
        return -1;
    }

    private int getVisibility(int memberIndex) throws CoreException {
        int visibilityBitOffset = memberIndex % 4;
        long visibilityOffset = this.record + 24L + (long)(memberIndex / 4);
        int visibility = this.getDB().getByte(visibilityOffset);
        visibility >>>= visibilityBitOffset * 2;
        return visibility &= 3;
    }
}

