/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfEdge;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.internal.analysis.graph.core.base.TmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.TmfEdgeLegacyWrapper;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.TmfVertexLegacyWrapper;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;

public class TmfGraphLegacyWrapper
implements ITmfGraph {
    private final CountDownLatch fFinishedLatch = new CountDownLatch(1);
    private final TmfGraph fGraph;

    public TmfGraphLegacyWrapper(TmfGraph graph) {
        this.fGraph = graph;
    }

    public TmfGraphLegacyWrapper() {
        this.fGraph = new TmfGraph();
    }

    @Override
    public ITmfVertex createVertex(IGraphWorker worker, long timestamp) {
        TmfVertex tmfVertex = new TmfVertex(timestamp);
        return new TmfVertexLegacyWrapper(worker, tmfVertex);
    }

    @Override
    public void add(ITmfVertex vertex) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper legacyVertex = (TmfVertexLegacyWrapper)vertex;
        this.fGraph.add(legacyVertex.getWorker(), legacyVertex.getVertex());
    }

    @Override
    public @Nullable ITmfEdge appendUnknown(ITmfVertex vertex) {
        return this.append(vertex, new OSEdgeContextState(TmfEdge.EdgeType.UNKNOWN), null);
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex) {
        return this.append(vertex, new OSEdgeContextState(TmfEdge.EdgeType.DEFAULT), null);
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex, ITmfEdgeContextState contextState) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        return this.append(vertex, contextState, null);
    }

    @Override
    public @Nullable ITmfEdge append(ITmfVertex vertex, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper legacyVertex = (TmfVertexLegacyWrapper)vertex;
        TmfEdge edge = linkQualifier == null ? this.fGraph.append(legacyVertex.getWorker(), legacyVertex.getVertex(), TmfEdgeLegacyWrapper.newTypeToOldType((OSEdgeContextState)contextState)) : this.fGraph.append(legacyVertex.getWorker(), legacyVertex.getVertex(), TmfEdgeLegacyWrapper.newTypeToOldType((OSEdgeContextState)contextState), linkQualifier);
        return edge == null ? null : new TmfEdgeLegacyWrapper(edge, new TmfVertexLegacyWrapper(legacyVertex.getWorker(), edge.getVertexFrom()), legacyVertex);
    }

    @Override
    public @Nullable ITmfEdge edgeUnknown(ITmfVertex from, ITmfVertex to) {
        return this.edge(from, to, new OSEdgeContextState(TmfEdge.EdgeType.UNKNOWN));
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to) {
        return this.edge(from, to, new OSEdgeContextState(TmfEdge.EdgeType.DEFAULT));
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState) {
        return this.edge(from, to, contextState, null);
    }

    @Override
    public @Nullable ITmfEdge edge(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
        if (!(from instanceof TmfVertexLegacyWrapper) || !(to instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper fromVertex = (TmfVertexLegacyWrapper)from;
        TmfVertexLegacyWrapper toVertex = (TmfVertexLegacyWrapper)to;
        if (from.equals(to)) {
            throw new IllegalArgumentException("A node cannot link to itself");
        }
        IGraphWorker parentOf = this.fGraph.getParentOf(toVertex.getVertex());
        if (parentOf == null) {
            this.fGraph.add(toVertex.getWorker(), toVertex.getVertex());
        }
        TmfEdge link = linkQualifier == null ? this.fGraph.link(fromVertex.getVertex(), toVertex.getVertex(), TmfEdgeLegacyWrapper.newTypeToOldType((OSEdgeContextState)contextState)) : this.fGraph.link(fromVertex.getVertex(), toVertex.getVertex(), TmfEdgeLegacyWrapper.newTypeToOldType((OSEdgeContextState)contextState), linkQualifier);
        return new TmfEdgeLegacyWrapper(link, fromVertex, toVertex);
    }

    @Override
    public @Nullable ITmfEdge edgeVertical(ITmfVertex from, ITmfVertex to, ITmfEdgeContextState contextState, @Nullable String linkQualifier) {
        if (!(from instanceof TmfVertexLegacyWrapper) || !(to instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper fromVertex = (TmfVertexLegacyWrapper)from;
        TmfVertexLegacyWrapper toVertex = (TmfVertexLegacyWrapper)to;
        if (from.equals(to)) {
            throw new IllegalArgumentException("A node cannot link to itself");
        }
        return new TmfEdgeLegacyWrapper(fromVertex.getVertex().linkVertical(toVertex.getVertex(), TmfEdgeLegacyWrapper.newTypeToOldType((OSEdgeContextState)contextState), linkQualifier), fromVertex, toVertex);
    }

    @Override
    public @Nullable ITmfVertex getTail(IGraphWorker worker) {
        TmfVertex tail = this.fGraph.getTail(worker);
        return tail == null ? null : new TmfVertexLegacyWrapper(worker, tail);
    }

    @Override
    public @Nullable ITmfVertex getHead(IGraphWorker worker) {
        TmfVertex head = this.fGraph.getHead(worker);
        return head == null ? null : new TmfVertexLegacyWrapper(worker, head);
    }

    @Override
    public @Nullable ITmfVertex getHead() {
        TmfVertex head = this.fGraph.getHead();
        return head == null ? null : new TmfVertexLegacyWrapper(Objects.requireNonNull(this.fGraph.getParentOf(head)), head);
    }

    @Override
    public ITmfVertex getHead(ITmfVertex vertex) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertex head = this.fGraph.getHead(((TmfVertexLegacyWrapper)vertex).getVertex());
        IGraphWorker parent = this.fGraph.getParentOf(head);
        if (parent == null) {
            throw new NullPointerException("Parent of vertex should not be null");
        }
        return new TmfVertexLegacyWrapper(parent, head);
    }

    @Override
    public Iterator<ITmfVertex> getNodesOf(IGraphWorker obj) {
        List nodesOf = this.fGraph.getNodesOf(obj).stream().map(lg -> new TmfVertexLegacyWrapper(obj, (TmfVertex)lg)).collect(Collectors.toList());
        return Objects.requireNonNull(nodesOf.iterator());
    }

    @Override
    public @Nullable IGraphWorker getParentOf(ITmfVertex vertex) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper legacyVertex = (TmfVertexLegacyWrapper)vertex;
        return this.fGraph.getParentOf(legacyVertex.getVertex());
    }

    public Set<IGraphWorker> getWorkers() {
        return this.fGraph.getWorkers();
    }

    @Override
    public @Nullable ITmfVertex getVertexAt(ITmfTimestamp startTime, IGraphWorker worker) {
        TmfVertex vertexAt = this.fGraph.getVertexAt(startTime, worker);
        return vertexAt == null ? null : new TmfVertexLegacyWrapper(worker, vertexAt);
    }

    @Override
    public boolean isDoneBuilding() {
        return this.fFinishedLatch.getCount() == 0L;
    }

    @Override
    public void closeGraph(long endTime) {
        this.fFinishedLatch.countDown();
    }

    @Override
    public @Nullable ITmfEdge getEdgeFrom(ITmfVertex vertex, ITmfGraph.EdgeDirection direction) {
        if (!(vertex instanceof TmfVertexLegacyWrapper)) {
            throw new IllegalArgumentException("Wrong vertex class");
        }
        TmfVertexLegacyWrapper legacyVertex = (TmfVertexLegacyWrapper)vertex;
        TmfEdge edge = legacyVertex.getVertex().getEdge(TmfVertexLegacyWrapper.newDirectionToOldDirection(direction));
        if (edge == null) {
            return null;
        }
        switch (direction) {
            case INCOMING_VERTICAL_EDGE: 
            case INCOMING_HORIZONTAL_EDGE: {
                TmfVertex vertexFrom = edge.getVertexFrom();
                return new TmfEdgeLegacyWrapper(edge, new TmfVertexLegacyWrapper(Objects.requireNonNull(this.fGraph.getParentOf(vertexFrom)), vertexFrom), legacyVertex);
            }
            case OUTGOING_VERTICAL_EDGE: 
            case OUTGOING_HORIZONTAL_EDGE: {
                TmfVertex vertexTo = edge.getVertexTo();
                return new TmfEdgeLegacyWrapper(edge, legacyVertex, new TmfVertexLegacyWrapper(Objects.requireNonNull(this.fGraph.getParentOf(vertexTo)), vertexTo));
            }
        }
        return null;
    }

    @Override
    public void dispose() {
    }
}

