/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.OutputElementStyle;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Sampling;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.XYAxisDescription;

@Schema(description="This model includes the series output style values.")
public interface SeriesModel {
    @Schema(description="Series' ID", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getSeriesId();

    @Schema(description="Series' name", requiredMode=Schema.RequiredMode.REQUIRED)
    public @NonNull String getSeriesName();

    @JsonProperty(value="xValues")
    @Schema(description="Sampling values", requiredMode=Schema.RequiredMode.REQUIRED, oneOf={Sampling.TimestampSampling.class, Sampling.CategorySampling.class, Sampling.RangeSampling.class})
    public Sampling getXValues();

    @JsonProperty(value="yValues")
    @ArraySchema(arraySchema=@Schema(description="Series' Y values"), schema=@Schema(requiredMode=Schema.RequiredMode.REQUIRED))
    public double[] getYValues();

    @JsonProperty(value="xValuesDescription")
    @ArraySchema(arraySchema=@Schema(description="Series' X axis description"), schema=@Schema(requiredMode=Schema.RequiredMode.REQUIRED))
    public XYAxisDescription getXAxisDescription();

    @JsonProperty(value="yValuesDescription")
    @ArraySchema(arraySchema=@Schema(description="Series' Y axis description"), schema=@Schema(requiredMode=Schema.RequiredMode.REQUIRED))
    public XYAxisDescription getYAxisDescription();

    @Schema(requiredMode=Schema.RequiredMode.REQUIRED)
    public @NonNull OutputElementStyle getStyle();
}

