/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.ISourceEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class InternalCoreModelUtil {
    public static void addSourceEntry(IProject project, IFolder folder, boolean removeProject, IProgressMonitor monitor) throws CoreException {
        CSourceEntry newEntry = new CSourceEntry(folder, null, 0);
        ICProjectDescription des = CCorePlugin.getDefault().getProjectDescription(project, true);
        InternalCoreModelUtil.addEntryToAllCfgs(des, newEntry, removeProject);
        CCorePlugin.getDefault().setProjectDescription(project, des, false, monitor);
    }

    private static void addEntryToAllCfgs(ICProjectDescription des, ICSourceEntry entry, boolean removeProject) throws WriteAccessException, CoreException {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ICSourceEntry[] entries = cfg.getSourceEntries();
            entries = InternalCoreModelUtil.addEntry(entries, entry, removeProject);
            cfg.setSourceEntries(entries);
            ++n2;
        }
    }

    private static ICSourceEntry[] addEntry(ICSourceEntry[] entries, ICSourceEntry sourceEntry, boolean removeProject) {
        HashSet<ICSourceEntry> set = new HashSet<ICSourceEntry>();
        ICSourceEntry[] iCSourceEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry entry = iCSourceEntryArray[n2];
            if (!removeProject || new Path(entry.getValue()).segmentCount() != 1) {
                set.add(entry);
            }
            ++n2;
        }
        set.add(sourceEntry);
        return set.toArray(new ICSourceEntry[set.size()]);
    }

    public static void addExclusionPatterns(IPathEntry newEntry, List<IPathEntry> existing, Set<IPathEntry> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.size()) {
            IPath[] exclusionFilters;
            IPathEntry curr = existing.get(i);
            IPath currPath = curr.getPath();
            if (curr.getEntryKind() == 8 && currPath.isPrefixOf(entryPath) && !CoreModelUtil.isExcludedPath(entryPath, exclusionFilters = ((ISourceEntry)curr).getExclusionPatterns())) {
                IPath pathToExclude = entryPath.removeFirstSegments(currPath.segmentCount()).addTrailingSeparator();
                IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
                System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
                newExclusionFilters[exclusionFilters.length] = pathToExclude;
                ISourceEntry updated = CoreModel.newSourceEntry(currPath, newExclusionFilters);
                existing.set(i, updated);
                modifiedEntries.add(updated);
            }
            ++i;
        }
    }

    public static ICConfigurationDescription findBuildConfiguration(IResource resource) {
        IPath location = resource.getLocation();
        IProject project = resource.getProject();
        ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(project, false);
        if (projectDesc == null) {
            return null;
        }
        ICConfigurationDescription[] iCConfigurationDescriptionArray = projectDesc.getConfigurations();
        int n = iCConfigurationDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            CBuildData buildData;
            ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n2];
            CConfigurationData configData = configDesc.getConfigurationData();
            if (configData != null && (buildData = configData.getBuildData()) != null) {
                ICOutputEntry[] iCOutputEntryArray = buildData.getOutputDirectories();
                int n3 = iCOutputEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ICOutputEntry dir = iCOutputEntryArray[n4];
                    IPath dirLocation = CDataUtil.makeAbsolute(project, dir).getLocation();
                    if (dirLocation != null && dirLocation.isPrefixOf(location)) {
                        return configDesc;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static IPath getBuildCWD(ICConfigurationDescription configDesc) {
        IPath builderCWD = configDesc.getBuildSetting().getBuilderCWD();
        if (builderCWD != null) {
            ICdtVariableManager manager = CCorePlugin.getDefault().getCdtVariableManager();
            try {
                String cwd = builderCWD.toString();
                cwd = manager.resolveValue(cwd, "", null, configDesc);
                if (!cwd.isEmpty()) {
                    return new Path(cwd);
                }
            }
            catch (CdtVariableException e) {
                CCorePlugin.log((Throwable)((Object)e));
            }
        }
        return null;
    }
}

