/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.symbols;

import com.google.common.base.Objects;
import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;

public class TmfResolvedSymbol {
    public static final Comparator<TmfResolvedSymbol> COMPARATOR = Comparator.comparing(TmfResolvedSymbol::getBaseAddress);
    private final long fAddress;
    private final String fName;

    public TmfResolvedSymbol(long address, String name) {
        this.fAddress = address;
        this.fName = name;
    }

    public long getBaseAddress() {
        return this.fAddress;
    }

    public String getSymbolName() {
        return this.fName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fAddress, this.fName});
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TmfResolvedSymbol)) {
            return false;
        }
        TmfResolvedSymbol other = (TmfResolvedSymbol)obj;
        return this.fAddress == other.fAddress && this.fName.equals(other.fName);
    }

    public String toString() {
        return Long.toHexString(this.fAddress) + " " + this.fName;
    }
}

