/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.UUID;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.IndexingStatus;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.Trace;

@Schema(description="Experiment model")
public interface Experiment {
    @Schema(description="User defined name for the experiment", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getName();

    @JsonProperty(value="UUID")
    @Schema(description="The experiment's unique identifier", requiredMode=Schema.RequiredMode.REQUIRED)
    public UUID getUUID();

    @Schema(description="Current number of indexed events in the experiment", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getNbEvents();

    @Schema(description="The experiment's start time", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getStart();

    @Schema(description="The experiment's end time", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getEnd();

    @Schema(description="Status of the experiment indexing", requiredMode=Schema.RequiredMode.REQUIRED)
    public IndexingStatus getIndexingStatus();

    @ArraySchema(arraySchema=@Schema(description="The traces encapsulated by this experiment"), schema=@Schema(requiredMode=Schema.RequiredMode.REQUIRED))
    public List<Trace> getTraces();
}

