/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonEventRecordMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventIDParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventNameParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamIdParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public final class EventDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final EventDeclarationParser INSTANCE = new EventDeclarationParser();

    private EventDeclarationParser() {
    }

    @Override
    public EventDeclaration parse(ICTFMetadataNode eventDecl, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        EventDeclaration event = ((Param)param).fEvent;
        CTFTrace fTrace = ((Param)param).fTrace;
        if (eventDecl instanceof CTFJsonMetadataNode) {
            JsonStructureFieldMetadataNode payload;
            JsonEventRecordMetadataNode rec = (JsonEventRecordMetadataNode)eventDecl;
            String name = rec.getName();
            if (name != null) {
                event.setName(name);
            }
            long id = rec.getId();
            EventDeclarationParser.verifyEventId(event, id);
            event.setId(id);
            long streamId = rec.getDataStreamClassId();
            CTFStream ctfStream = EventDeclarationParser.verifyStream(fTrace, streamId);
            event.setStream(ctfStream);
            JsonStructureFieldMetadataNode context = rec.getSpecificContextClass();
            if (context != null) {
                IDeclaration contextDecl = TypeSpecifierListParser.INSTANCE.parse(rec.getSpecificContextClass(), new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                EventDeclarationParser.verifyContext(contextDecl);
                event.setContext((StructDeclaration)contextDecl);
            }
            if ((payload = rec.getPayloadFieldClass()) != null) {
                IDeclaration fieldsDecl = TypeSpecifierListParser.INSTANCE.parse(rec.getPayloadFieldClass(), new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StructDeclaration fields = EventDeclarationParser.verifyFieldsDeclaration(fieldsDecl);
                event.setFields(fields);
            }
        } else if (eventDecl instanceof CTFAntlrMetadataNode) {
            ICTFMetadataNode leftNode = eventDecl.getChild(0);
            ICTFMetadataNode rightNode = eventDecl.getChild(1);
            List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
            if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                throw new ParseException("left side of CTF assignment must be a string");
            }
            String left = TsdlUtils.concatenateUnaryStrings(leftStrings);
            if (left.equals("name")) {
                if (event.nameIsSet()) {
                    throw new ParseException("name already defined");
                }
                String name = EventNameParser.INSTANCE.parse(rightNode, null);
                event.setName(name);
            } else if (left.equals("id")) {
                long id = EventIDParser.INSTANCE.parse(rightNode, null);
                EventDeclarationParser.verifyEventId(event, id);
                event.setId((int)id);
            } else if (left.equals("stream_id")) {
                if (event.streamIsSet()) {
                    throw new ParseException("stream id already defined");
                }
                long streamId = StreamIdParser.INSTANCE.parse(rightNode, null);
                CTFStream ctfStream = EventDeclarationParser.verifyStream(fTrace, streamId);
                event.setStream(ctfStream);
            } else if (left.equals("context")) {
                if (event.contextIsSet()) {
                    throw new ParseException("context already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("context expects a type specifier");
                }
                IDeclaration contextDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                EventDeclarationParser.verifyContext(contextDecl);
                event.setContext((StructDeclaration)contextDecl);
            } else if (left.equals("fields")) {
                if (event.fieldsIsSet()) {
                    throw new ParseException("fields already defined");
                }
                ICTFMetadataNode typeSpecifier = rightNode.getChild(0);
                if (!CTFParser.tokenNames[117].equals(typeSpecifier.getType())) {
                    throw new ParseException("fields expects a type specifier");
                }
                IDeclaration fieldsDecl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifier, new TypeSpecifierListParser.Param(fTrace, null, null, scope));
                StructDeclaration fields = EventDeclarationParser.verifyFieldsDeclaration(fieldsDecl);
                event.setFields(fields);
            } else if (left.equals("loglevel")) {
                long logLevel = UnaryIntegerParser.INSTANCE.parse(rightNode.getChild(0), null);
                event.setLogLevel(logLevel);
            } else {
                String right = UnaryStringParser.INSTANCE.parse(rightNode.getChild(0), null);
                event.setCustomAttribute(left, right);
            }
        }
        return event;
    }

    private static void verifyContext(IDeclaration contextDecl) throws ParseException {
        if (!(contextDecl instanceof StructDeclaration)) {
            throw new ParseException("context expects a struct");
        }
    }

    private static StructDeclaration verifyFieldsDeclaration(IDeclaration fieldsDecl) throws ParseException {
        if (!(fieldsDecl instanceof StructDeclaration)) {
            throw new ParseException("fields expects a struct");
        }
        return (StructDeclaration)fieldsDecl;
    }

    private static CTFStream verifyStream(CTFTrace fTrace, long streamId) throws ParseException {
        ICTFStream iStream = fTrace.getStream(streamId);
        if (!(iStream instanceof CTFStream)) {
            throw new ParseException("Event specified stream with ID " + streamId + ". But no stream with that ID was defined");
        }
        return (CTFStream)iStream;
    }

    private static void verifyEventId(EventDeclaration event, long id) throws ParseException {
        if (event.idIsSet()) {
            throw new ParseException("id already defined");
        }
        if (id > Integer.MAX_VALUE) {
            throw new ParseException("id is greater than int.maxvalue, unsupported. id : " + id);
        }
        if (id < 0L) {
            throw new ParseException("negative id, unsupported. id : " + id);
        }
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final EventDeclaration fEvent;
        private final CTFTrace fTrace;
        private final DeclarationScope fDeclarationScope;

        public Param(CTFTrace trace, EventDeclaration event, DeclarationScope scope) {
            this.fTrace = trace;
            this.fEvent = event;
            this.fDeclarationScope = scope;
        }
    }
}

