/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Map;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component
public final class ResourceChangeListenerRegistrar {
    private final IWorkspace workspace;
    private Logger logger;

    @Activate
    public ResourceChangeListenerRegistrar(@Reference IWorkspace workspace) {
        this.workspace = workspace;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.AT_LEAST_ONE)
    public void addResourceChangeListener(IResourceChangeListener listener, Map<String, Object> properties) {
        Object mask = properties.get("event.mask");
        if (mask instanceof Integer) {
            this.workspace.addResourceChangeListener(listener, (Integer)mask);
        } else {
            Logger local = this.logger;
            if (mask != null && local != null) {
                local.warn("event.mask of IResourceChangeListener service: expected Integer but was {} (from {}): {}", new Object[]{mask.getClass(), listener.getClass(), mask});
            }
            this.workspace.addResourceChangeListener(listener);
        }
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.workspace.removeResourceChangeListener(listener);
    }

    @Reference(unbind="unsetLogger", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    public void setLoggerFactory(LoggerFactory factory) {
        this.logger = factory.getLogger(ResourceChangeListenerRegistrar.class);
    }

    public void unsetLogger(LoggerFactory factory) {
        this.logger = null;
    }
}

