/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.coff;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.utils.coff.ReadMemoryAccess;

public class Coff64 {
    public static final String NL = System.getProperty("line.separator", "\n");
    FileHeader filehdr;
    OptionalHeader opthdr;
    RandomAccessFile rfile;
    long startingOffset;
    byte[] string_table;
    SectionHeader[] scnhdrs;
    Symbol[] symbols;

    public FileHeader getFileHeader() throws IOException {
        return this.filehdr;
    }

    public OptionalHeader getOptionalHeader() throws IOException {
        return this.opthdr;
    }

    public SectionHeader[] getSectionHeaders() throws IOException {
        if (this.scnhdrs == null) {
            this.scnhdrs = new SectionHeader[this.getFileHeader().f_nscns];
            long sec = 20 + this.getFileHeader().f_opthdr;
            int i = 0;
            while (i < this.scnhdrs.length) {
                this.scnhdrs[i] = new SectionHeader(this.rfile, sec);
                ++i;
                sec += 40L;
            }
        }
        return this.scnhdrs;
    }

    public Symbol[] getSymbols() throws IOException {
        if (this.symbols == null) {
            long offset = this.getFileHeader().f_symptr;
            this.rfile.seek(offset);
            this.symbols = new Symbol[this.getFileHeader().f_nsyms];
            int i = 0;
            while (i < this.symbols.length) {
                this.symbols[i] = new Symbol(this.rfile, (this.getFileHeader().f_flags & 0x100) == 0);
                ++i;
            }
        }
        return this.symbols;
    }

    public byte[] getStringTable() throws IOException {
        if (this.string_table == null) {
            long symbolsize = 18 * this.getFileHeader().f_nsyms;
            long offset = (long)this.getFileHeader().f_symptr + symbolsize;
            this.rfile.seek(offset);
            byte[] bytes = new byte[4];
            this.rfile.readFully(bytes);
            int str_len = ReadMemoryAccess.getIntLE(bytes);
            if (str_len > 4 && (long)str_len < this.rfile.length()) {
                this.string_table = new byte[str_len -= 4];
                this.rfile.seek(offset + 4L);
                this.rfile.readFully(this.string_table);
            } else {
                this.string_table = new byte[0];
            }
        }
        return this.string_table;
    }

    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder();
        try {
            FileHeader header = null;
            header = this.getFileHeader();
            if (header != null) {
                buffer.append(header);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            OptionalHeader opt = null;
            opt = this.getOptionalHeader();
            if (opt != null) {
                buffer.append(opt);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            SectionHeader[] sections = this.getSectionHeaders();
            i = 0;
            while (i < sections.length) {
                buffer.append(sections[i]);
                ++i;
            }
        }
        catch (IOException sections) {
            // empty catch block
        }
        try {
            Symbol[] table = this.getSymbols();
            i = 0;
            while (i < table.length) {
                buffer.append(table[i].getName(this.getStringTable())).append(NL);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static String[] getStringTable(byte[] bytes) {
        ArrayList<String> aList = new ArrayList<String>();
        int offset = 0;
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == 0) {
                aList.add(new String(bytes, offset, i - offset));
                offset = i + 1;
            }
            ++i;
        }
        return aList.toArray(new String[0]);
    }

    public Coff64(String filename) throws IOException {
        this(new RandomAccessFile(filename, "r"), 0L);
    }

    public Coff64(RandomAccessFile file, long offset) throws IOException {
        this.commonSetup(file, offset);
    }

    void commonSetup(RandomAccessFile file, long offset) throws IOException {
        this.startingOffset = offset;
        this.rfile = file;
        try {
            this.filehdr = new FileHeader(this.rfile, offset);
            if (this.filehdr.f_opthdr > 0) {
                this.opthdr = new OptionalHeader(this.rfile, this.startingOffset + 20L);
            }
        }
        finally {
            if (this.filehdr == null) {
                this.rfile.close();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Coff64 coff = new Coff64(args[0]);
            System.out.println(coff);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class FileHeader {
        public static final int FILHSZ = 20;
        public static final int F_RELFLG = 1;
        public static final int F_EXEC = 2;
        public static final int F_LNNO = 4;
        public static final int F_LSYMS = 8;
        public static final int F_AR16WR = 128;
        public static final int F_AR32WR = 256;
        public static final int F_AR32W = 512;
        public static final int F_DYNLOAD = 4096;
        public static final int F_SHROBJ = 8192;
        public static final int F_DLL = 8192;
        public int f_magic;
        public int f_nscns;
        public int f_timdat;
        public int f_symptr;
        public int f_nsyms;
        public int f_opthdr;
        public int f_flags;

        public FileHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public FileHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[20];
            file.readFully(hdr);
            this.commonSetup(hdr, true);
        }

        public FileHeader(byte[] hdr, boolean little) throws EOFException {
            this.commonSetup(hdr, little);
        }

        public void commonSetup(byte[] hdr, boolean little) throws EOFException {
            if (hdr == null || hdr.length < 20) {
                throw new EOFException(CCorePlugin.getResourceString("Util.exception.arrayToSmall"));
            }
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, little);
            this.f_magic = memory.getUnsignedShort();
            this.f_nscns = memory.getUnsignedShort();
            this.f_timdat = memory.getInt();
            this.f_symptr = memory.getInt();
            this.f_nsyms = memory.getInt();
            this.f_opthdr = memory.getUnsignedShort();
            this.f_flags = memory.getUnsignedShort();
        }

        public boolean isStrip() {
            return (this.f_flags & 1) == 1;
        }

        public boolean isExec() {
            return (this.f_flags & 2) == 2;
        }

        public boolean isDebug() {
            return (this.f_flags & 4) != 4;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("FILE HEADER VALUES").append(NL);
            buffer.append("f_magic = ").append(this.f_magic).append(NL);
            buffer.append("f_nscns = ").append(this.f_nscns).append(NL);
            buffer.append("f_timdat = ");
            buffer.append(DateFormat.getDateInstance().format(new Date(this.f_timdat)));
            buffer.append(NL);
            buffer.append("f_symptr = ").append(this.f_symptr).append(NL);
            buffer.append("f_nsyms = ").append(this.f_nsyms).append(NL);
            buffer.append("f_opthdr = ").append(this.f_opthdr).append(NL);
            buffer.append("f_flags = ").append(this.f_flags).append(NL);
            return buffer.toString();
        }
    }

    public static class Lineno {
        public static final int LINESZ = 6;
        public int l_addr;
        public int l_lnno;

        public Lineno(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public Lineno(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] bytes = new byte[6];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, true);
            this.l_addr = memory.getInt();
            this.l_lnno = memory.getUnsignedShort();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.l_lnno == 0) {
                buffer.append("Function address = ").append(this.l_addr).append(NL);
            } else {
                buffer.append("line# ").append(this.l_lnno);
                buffer.append(" at address = ").append(this.l_addr).append(NL);
            }
            return buffer.toString();
        }
    }

    public static class OptionalHeader {
        public short magic;
        public OptionalHeader64 optionalHeader64;
        public OptionalHeader32 optionalHeader32;
        private static final int MAGICSZ = 2;
        private boolean is64Bits;

        public OptionalHeader(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer() + 20L);
        }

        public OptionalHeader(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] hdr = new byte[2];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            this.magic = memory.getShort();
            if (this.magic == 523) {
                this.optionalHeader64 = new OptionalHeader64(file, file.getFilePointer());
                this.is64Bits = true;
            } else if (this.magic == 267) {
                this.optionalHeader32 = new OptionalHeader32(file, file.getFilePointer());
                this.is64Bits = false;
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("OPTIONAL HEADER VALUES").append(NL);
            buffer.append("magic      = ").append(this.magic).append(NL);
            if (this.is64Bits()) {
                buffer.append(this.optionalHeader64.toString());
            } else {
                buffer.append(this.optionalHeader32.toString());
            }
            return buffer.toString();
        }

        public boolean is64Bits() {
            return this.is64Bits;
        }

        public int getSize() {
            if (this.is64Bits()) {
                return 22;
            }
            return 26;
        }

        public static class OptionalHeader32 {
            public static final int AOUTHDRSZ = 26;
            public short vstamp;
            public int tsize;
            public int dsize;
            public int bsize;
            public int entry;
            public int text_start;
            public int data_start;

            public OptionalHeader32(RandomAccessFile file, long offset) throws IOException {
                file.seek(offset);
                byte[] hdr = new byte[26];
                file.readFully(hdr);
                ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
                this.vstamp = memory.getShort();
                this.tsize = memory.getInt();
                this.dsize = memory.getInt();
                this.bsize = memory.getInt();
                this.entry = memory.getInt();
                this.text_start = memory.getInt();
                this.data_start = memory.getInt();
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                buffer.append("vstamp     = ").append(this.vstamp).append(NL);
                buffer.append("tsize      = ").append(this.tsize).append(NL);
                buffer.append("dsize      = ").append(this.dsize).append(NL);
                buffer.append("bsize      = ").append(this.bsize).append(NL);
                buffer.append("entry      = ").append(this.entry).append(NL);
                buffer.append("text_start = ").append(this.text_start).append(NL);
                buffer.append("data_start = ").append(this.data_start).append(NL);
                return buffer.toString();
            }
        }

        public static class OptionalHeader64 {
            public static final int AOUTHDRSZ = 22;
            public short vstamp;
            public int tsize;
            public int dsize;
            public int bsize;
            public int entry;
            public int text_start;

            public OptionalHeader64(RandomAccessFile file, long offset) throws IOException {
                file.seek(offset);
                byte[] hdr = new byte[22];
                file.readFully(hdr);
                ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
                this.vstamp = memory.getShort();
                this.tsize = memory.getInt();
                this.dsize = memory.getInt();
                this.bsize = memory.getInt();
                this.entry = memory.getInt();
                this.text_start = memory.getInt();
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                buffer.append("vstamp     = ").append(this.vstamp).append(NL);
                buffer.append("tsize      = ").append(this.tsize).append(NL);
                buffer.append("dsize      = ").append(this.dsize).append(NL);
                buffer.append("bsize      = ").append(this.bsize).append(NL);
                buffer.append("entry      = ").append(this.entry).append(NL);
                buffer.append("text_start = ").append(this.text_start).append(NL);
                return buffer.toString();
            }
        }
    }

    public static class Reloc {
        public static final int RELSZ = 16;
        public int r_vaddr;
        public int r_symndx;
        public int r_type;

        public Reloc(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer());
        }

        public Reloc(RandomAccessFile file, long offset) throws IOException {
            file.seek(offset);
            byte[] bytes = new byte[16];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, true);
            this.r_vaddr = memory.getInt();
            this.r_symndx = memory.getInt();
            this.r_type = memory.getUnsignedShort();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("RELOC VALUES").append(NL);
            buffer.append("r_vaddr = ").append(this.r_vaddr);
            buffer.append(" r_symndx = ").append(this.r_symndx).append(NL);
            return buffer.toString();
        }
    }

    public static class SectionHeader {
        public static final int SCNHSZ = 40;
        public static final String _TEXT = ".text";
        public static final String _DATA = ".data";
        public static final String _BSS = ".bss";
        public static final String _COMMENT = ".comment";
        public static final String _LIB = ".lib";
        public static final int STYP_REG = 0;
        public static final int STYP_DSECT = 1;
        public static final int STYP_NOLOAD = 2;
        public static final int STYP_GROUP = 4;
        public static final int STYP_PAD = 8;
        public static final int STYP_COPY = 16;
        public static final int STYP_TEXT = 32;
        public static final int S_SHRSEG = 32;
        public static final int STYP_DATA = 64;
        public static final int STYP_BSS = 128;
        public static final int S_NEWFCN = 256;
        public static final int STYP_INFO = 512;
        public static final int STYP_OVER = 1024;
        public static final int STYP_LIB = 2048;
        public static final int STYP_MERGE = 8192;
        public static final int STYP_REVERSE_PAD = 16384;
        public static final int STYP_LIT = 32800;
        public static final int STYP_MEM_DISCARDABLE = 0x2000000;
        public static final int STYP_MEM_WRITE = Integer.MIN_VALUE;
        public byte[] s_name = new byte[8];
        public int s_paddr;
        public int s_vaddr;
        public int s_size;
        public int s_scnptr;
        public int s_relptr;
        public int s_lnnoptr;
        public int s_nreloc;
        public int s_nlnno;
        public int s_flags;
        RandomAccessFile sfile;
        private final long objOffset;

        public SectionHeader(RandomAccessFile file, long hdrOffset) throws IOException {
            this(file, 0L, hdrOffset);
        }

        public SectionHeader(RandomAccessFile file, long objOffset, long hdrOffset) throws IOException {
            this.sfile = file;
            this.objOffset = objOffset;
            file.seek(hdrOffset + objOffset);
            byte[] hdr = new byte[40];
            file.readFully(hdr);
            ReadMemoryAccess memory = new ReadMemoryAccess(hdr, true);
            memory.getBytes(this.s_name);
            this.s_paddr = memory.getInt();
            this.s_vaddr = memory.getInt();
            this.s_size = memory.getInt();
            this.s_scnptr = memory.getInt();
            this.s_relptr = memory.getInt();
            this.s_lnnoptr = memory.getInt();
            this.s_nreloc = memory.getUnsignedShort();
            this.s_nlnno = memory.getUnsignedShort();
            this.s_flags = memory.getInt();
        }

        public byte[] getRawData() throws IOException {
            byte[] data = new byte[this.s_size];
            this.sfile.seek(this.s_scnptr);
            this.sfile.readFully(data);
            return data;
        }

        public Reloc[] getRelocs() throws IOException {
            Reloc[] relocs = new Reloc[this.s_nreloc];
            this.sfile.seek(this.s_relptr);
            int i = 0;
            while (i < this.s_nreloc) {
                relocs[i] = new Reloc(this.sfile);
                ++i;
            }
            return relocs;
        }

        public Lineno[] getLinenos() throws IOException {
            Lineno[] lines = new Lineno[this.s_nlnno];
            this.sfile.seek(this.s_lnnoptr);
            int i = 0;
            while (i < this.s_nlnno) {
                lines[i] = new Lineno(this.sfile);
                ++i;
            }
            return lines;
        }

        public String toString() {
            int i;
            StringBuilder buffer = new StringBuilder();
            buffer.append("SECTION HEADER VALUES").append(NL);
            buffer.append(new String(this.s_name)).append(NL);
            buffer.append("s_paddr = ").append(this.s_paddr).append(NL);
            buffer.append("s_vaddr = ").append(this.s_vaddr).append(NL);
            buffer.append("s_size = ").append(this.s_size).append(NL);
            buffer.append("s_scnptr = ").append(this.s_scnptr).append(NL);
            buffer.append("s_relptr = ").append(this.s_relptr).append(NL);
            buffer.append("s_lnnoptr = ").append(this.s_lnnoptr).append(NL);
            buffer.append("s_nreloc = ").append(this.s_nreloc).append(NL);
            buffer.append("s_nlnno = ").append(this.s_nlnno).append(NL);
            buffer.append("s_flags = ").append(this.s_flags).append(NL);
            try {
                Reloc[] rcs = this.getRelocs();
                i = 0;
                while (i < rcs.length) {
                    buffer.append(rcs[i]);
                    ++i;
                }
            }
            catch (IOException rcs) {
                // empty catch block
            }
            try {
                Lineno[] nos = this.getLinenos();
                i = 0;
                while (i < nos.length) {
                    buffer.append(nos[i]);
                    ++i;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return buffer.toString();
        }

        public ByteBuffer mapSectionData() throws IOException {
            long size = this.s_paddr == 0 ? this.s_size : this.s_paddr;
            return this.sfile.getChannel().map(FileChannel.MapMode.READ_ONLY, (long)this.s_scnptr + this.objOffset, size).load().asReadOnlyBuffer();
        }
    }

    public static class Symbol {
        public static final int SYMSZ = 18;
        public static final int SYMNMLEN = 8;
        public static final int DT_NON = 0;
        public static final int DT_PTR = 1;
        public static final int DT_FCN = 2;
        public static final int DT_ARY = 3;
        public static final int N_TMASK = 48;
        public static final int N_BTSHFT = 4;
        public static final int N_TSHIFT = 2;
        public static final int T_NULL = 0;
        public static final int T_VOID = 1;
        public static final int T_CHAR = 2;
        public static final int T_SHORT = 3;
        public static final int T_INT = 4;
        public static final int T_LONG = 5;
        public static final int T_FLOAT = 6;
        public static final int T_DOUBLE = 7;
        public static final int T_STRUCT = 8;
        public static final int T_UNION = 9;
        public static final int T_ENUM = 16;
        public static final int T_MOE = 17;
        public static final int T_UCHAR = 18;
        public static final int T_USHORT = 19;
        public static final int T_UINT = 20;
        public static final int T_ULONG = 21;
        public static final int T_LNGDBL = 22;
        public static final int SC_EXTERNAL = 2;
        public byte[] _n_name = new byte[8];
        public int n_value;
        public short n_scnum;
        public int n_type;
        public byte n_sclass;
        public byte n_numaux;
        public short n_aux_lnno;
        public short n_aux_size;
        public int n_aux_fcn_size;
        private boolean is64Bit;

        public Symbol(RandomAccessFile file) throws IOException {
            this(file, file.getFilePointer(), false);
        }

        public Symbol(RandomAccessFile file, long offset) throws IOException {
            this(file, offset, false);
        }

        public Symbol(RandomAccessFile file, boolean is64Bit) throws IOException {
            this(file, file.getFilePointer(), is64Bit);
        }

        public Symbol(RandomAccessFile file, long offset, boolean is64Bit) throws IOException {
            this.is64Bit = is64Bit;
            file.seek(offset);
            byte[] bytes = new byte[18];
            file.readFully(bytes);
            ReadMemoryAccess memory = new ReadMemoryAccess(bytes, true);
            memory.getBytes(this._n_name);
            this.n_value = memory.getInt();
            this.n_scnum = memory.getShort();
            this.n_type = memory.getUnsignedShort();
            this.n_sclass = memory.getByte();
            this.n_numaux = memory.getByte();
            if (this.n_numaux > 0) {
                byte[] bytes2 = new byte[18 * this.n_numaux];
                file.readFully(bytes2);
                memory = new ReadMemoryAccess(bytes2, true);
                memory.getInt();
                this.n_aux_lnno = memory.getShort();
                this.n_aux_size = memory.getShort();
                memory = new ReadMemoryAccess(bytes2, true);
                memory.getInt();
                this.n_aux_fcn_size = memory.getInt();
            }
        }

        public boolean isLongName() {
            return this._n_name[0] == 0;
        }

        public String getName() {
            int i = 0;
            while (i < this._n_name.length) {
                if (this._n_name[i] == 0) {
                    return new String(this._n_name, 0, i);
                }
                ++i;
            }
            return new String(this._n_name);
        }

        public String getName(byte[] table) {
            if (table.length > 0 && this.isLongName()) {
                ReadMemoryAccess memory = new ReadMemoryAccess(this._n_name, true);
                memory.getInt();
                int offset = memory.getInt() - 4;
                if (offset > 0) {
                    int i = offset;
                    while (i < table.length) {
                        if (table[i] == 0) {
                            return new String(table, offset, i - offset);
                        }
                        ++i;
                    }
                }
            }
            return this.getName();
        }

        public boolean isNoSymbol() {
            return this.n_type == 0;
        }

        public boolean isPointer() {
            return (this.n_type & 0x30) == 16;
        }

        public boolean isFunction() {
            return (this.n_type & 0x30) == 32;
        }

        public boolean isArray() {
            return (this.n_type & 0x30) == 48;
        }

        public int getSize() {
            if (this.n_type <= 22) {
                switch (this.n_type) {
                    case 2: 
                    case 18: {
                        return 1;
                    }
                    case 3: 
                    case 19: {
                        return 2;
                    }
                    case 5: 
                    case 21: {
                        return 4;
                    }
                    case 4: 
                    case 20: {
                        return 4;
                    }
                    case 6: {
                        return 4;
                    }
                    case 7: {
                        return 8;
                    }
                    case 17: {
                        return 4;
                    }
                    case 22: {
                        return 16;
                    }
                    case 8: 
                    case 9: 
                    case 16: {
                        return this.n_aux_size;
                    }
                }
            } else {
                if (this.isFunction()) {
                    return this.n_aux_fcn_size;
                }
                if (this.isArray()) {
                    return this.n_aux_size;
                }
                if (this.isPointer()) {
                    return this.is64Bit ? 8 : 4;
                }
            }
            return 1;
        }

        public String toString() {
            return this.getName();
        }
    }
}

