/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;

class PDOMCPPAnnotations {
    private static final int VISIBILITY_OFFSET = 0;
    private static final int VISIBILITY_MASK = 3;
    private static final int EXTERN_OFFSET = 2;
    private static final int MUTABLE_OFFSET = 3;
    private static final int STATIC_OFFSET = 4;
    private static final int CONSTEXPR_OFFSET = 5;
    private static final int INLINE_OFFSET = 3;
    private static final int EXTERN_C_OFFSET = 0;
    private static final int VARARGS_OFFSET = 6;
    private static final int PARAMETER_PACK_OFFSET = 7;
    private static final int DELETED_OFFSET = 8;
    private static final int NO_RETURN_OFFSET = 9;
    private static final int NO_DISCARD_OFFSET = 10;
    private static final int VIRTUAL_OFFSET = 0;
    private static final int DESTRUCTOR_OFFSET = 1;
    private static final int IMPLICIT_OFFSET = 2;
    private static final int EXPLICIT_OFFSET = 3;
    private static final int PURE_VIRTUAL_OFFSET = 4;
    private static final int OVERRIDE_OFFSET = 5;
    private static final int FINAL_OFFSET = 6;

    PDOMCPPAnnotations() {
    }

    public static short encodeFunctionAnnotations(ICPPFunction function) {
        short annotation = PDOMCPPAnnotations.encodeVisibility(function);
        if (function.isExtern()) {
            annotation = (short)(annotation | 4);
        }
        if (ASTInternal.isStatic(function, false)) {
            annotation = (short)(annotation | 0x10);
        }
        if (function.isInline()) {
            annotation = (short)(annotation | 8);
        }
        if (function.takesVarArgs()) {
            annotation = (short)(annotation | 0x40);
        }
        if (function.isNoReturn()) {
            annotation = (short)(annotation | 0x200);
        }
        if (function.isExternC()) {
            annotation = (short)(annotation | 1);
        }
        if (function.isConstexpr()) {
            annotation = (short)(annotation | 0x20);
        }
        if (function.hasParameterPack()) {
            annotation = (short)(annotation | 0x80);
        }
        if (function.isDeleted()) {
            annotation = (short)(annotation | 0x100);
        }
        if (function.isNoDiscard()) {
            annotation = (short)(annotation | 0x400);
        }
        return annotation;
    }

    public static byte encodeVariableAnnotations(ICPPVariable variable) {
        byte annotation = PDOMCPPAnnotations.encodeVisibility(variable);
        if (variable.isExtern()) {
            annotation = (byte)(annotation | 4);
        }
        if (variable.isStatic()) {
            annotation = (byte)(annotation | 0x10);
        }
        if (variable.isExternC()) {
            annotation = (byte)(annotation | 1);
        }
        if (variable.isConstexpr()) {
            annotation = (byte)(annotation | 0x20);
        }
        if (variable instanceof ICPPField && ((ICPPField)variable).isMutable()) {
            annotation = (byte)(annotation | 8);
        }
        return annotation;
    }

    private static byte encodeVisibility(ICPPBinding binding) {
        byte annotation = 0;
        if (binding instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)binding;
            annotation = (byte)((member.getVisibility() & 3) << 0);
        }
        return annotation;
    }

    public static byte encodeExtraMethodAnnotations(IBinding binding) {
        byte annotation = 0;
        if (binding instanceof ICPPMethod) {
            ICPPMethod method = (ICPPMethod)binding;
            if (method.isVirtual()) {
                annotation = (byte)(annotation | 1);
            }
            if (method.isDestructor()) {
                annotation = (byte)(annotation | 2);
            }
            if (method.isImplicit()) {
                annotation = (byte)(annotation | 4);
            }
            if (method.isPureVirtual()) {
                annotation = (byte)(annotation | 0x10);
            }
            if (method.isExplicit()) {
                annotation = (byte)(annotation | 8);
            }
            if (method.isOverride()) {
                annotation = (byte)(annotation | 0x20);
            }
            if (method.isFinal()) {
                annotation = (byte)(annotation | 0x40);
            }
        }
        return annotation;
    }

    public static int getVisibility(short annotation) {
        return annotation >> 0 & 3;
    }

    public static boolean isExtern(short annotation) {
        return (annotation & 4) != 0;
    }

    public static boolean isMutable(short annotation) {
        return (annotation & 8) != 0;
    }

    public static boolean isStatic(short annotation) {
        return (annotation & 0x10) != 0;
    }

    public static boolean isConstexpr(short annotation) {
        return (annotation & 0x20) != 0;
    }

    public static boolean isInline(short annotation) {
        return (annotation & 8) != 0;
    }

    public static boolean isExternC(short annotation) {
        return (annotation & 1) != 0;
    }

    public static boolean isVarargsFunction(short annotation) {
        return (annotation & 0x40) != 0;
    }

    public static boolean hasParameterPack(short annotation) {
        return (annotation & 0x80) != 0;
    }

    public static boolean isDeletedFunction(short annotation) {
        return (annotation & 0x100) != 0;
    }

    public static boolean isNoReturnFunction(short annotation) {
        return (annotation & 0x200) != 0;
    }

    public static boolean isNoDiscardFunction(short annotation) {
        return (annotation & 0x400) != 0;
    }

    public static boolean isVirtualMethod(byte annotation) {
        return (annotation & 1) != 0;
    }

    public static boolean isDestructor(byte annotation) {
        return (annotation & 2) != 0;
    }

    public static boolean isImplicitMethod(byte annotation) {
        return (annotation & 4) != 0;
    }

    public static boolean isExplicitMethod(byte annotation) {
        return (annotation & 8) != 0;
    }

    public static boolean isPureVirtualMethod(byte annotation) {
        return (annotation & 0x10) != 0;
    }

    public static boolean isOverrideMethod(byte annotation) {
        return (annotation & 0x20) != 0;
    }

    public static boolean isFinalMethod(byte annotation) {
        return (annotation & 0x40) != 0;
    }

    public static byte clearImplicitMethodFlag(byte annotation) {
        return (byte)(annotation & 0xFFFFFFFB);
    }
}

