/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.counters.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.xychart.TmfChartView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.Assert;
import org.junit.Test;

public class NewCounterViewPinAndCloneTest
extends XYDataProviderBaseTest {
    private static final String TRACETYPE_ID = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String TRACE_NAME = "kernel_vm";
    private static final @NonNull String COUNTERS_VIEW_TITLE = "Counters";
    private static final @NonNull String MAIN_SERIES_NAME = "kernel_vm/Ungrouped/minor_faults";
    private static final @NonNull String COUNTERS_VIEW_ID = "org.eclipse.tracecompass.analysis.counters.ui.views.countersview";
    private static final String PINNED_TO_TRACE_COUNTERS_VIEW_TITLE = "Counters <kernel_vm>";
    private static final String PINNED_TO_CTX_SWITCH_VIEW_TITLE = "Counters <context-switches-kernel>";
    private static final String PIN_VIEW_BUTTON_NAME = "Pin View";
    private static final String UNPIN_VIEW_BUTTON_NAME = "Unpin View";
    private static final String PIN_TO_PREFIX = "Pin to ";
    private static final String NEW_COUNTER_STACK_MENU = "New Counters view";
    private static final String PINNED_TO_PREFIX = "pinned to ";
    private static final String CLONED_TRACE_SUFFIX = " | 2";
    private static final String CLONED_VIEW_TITLE_NAME = "Counters <kernel_vm | 2>";
    private static final int SECOND = 1000000000;
    private static final long KERNEL_START = 1363700740555978750L;
    private static final long KERNEL_TEST_START = 1363700741555978750L;
    private static final long KERNEL_TEST_END = 1363700742555978750L;
    private static final long KERNEL_TEST_INITIAL_END = 1363700740655978750L;
    private static final long KERNEL_INITIAL_END = 1363700740655978750L;
    private static final @NonNull TmfTimeRange RANGE = new TmfTimeRange(TmfTimestamp.fromNanos((long)1363700741555978750L), TmfTimestamp.fromNanos((long)1363700742555978750L));

    @Test
    public void testPinSingleTrace() {
        final SWTBotView originalViewBot = this.getSWTBotView();
        Assert.assertEquals((Object)COUNTERS_VIEW_TITLE, (Object)originalViewBot.getTitle());
        fBot.waitUntil((ICondition)new DefaultCondition(){
            WidgetNotFoundException fException;

            public boolean test() throws Exception {
                try {
                    SWTBotToolbarDropDownButton toolbarDropDownButton = originalViewBot.toolbarDropDownButton(NewCounterViewPinAndCloneTest.PIN_VIEW_BUTTON_NAME);
                    toolbarDropDownButton.menuItem(NewCounterViewPinAndCloneTest.PIN_TO_PREFIX + NewCounterViewPinAndCloneTest.this.getTestTrace().getName()).click();
                    return true;
                }
                catch (WidgetNotFoundException e) {
                    this.fException = e;
                    return false;
                }
            }

            public String getFailureMessage() {
                return "Traces not available in toolbar drop down menu: " + String.valueOf((Object)this.fException);
            }
        });
        this.assertOriginalViewTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        originalViewBot.toolbarButton(UNPIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(COUNTERS_VIEW_TITLE);
        originalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        originalViewBot.toolbarButton(UNPIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(COUNTERS_VIEW_TITLE);
    }

    @Test
    public void testPinTwoTraces() {
        final SWTBotView originalViewBot = this.getSWTBotView();
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        CtfTmfTrace kernelTestTrace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.CONTEXT_SWITCHES_KERNEL);
        SWTBotUtils.openTrace((String)"test", (String)kernelTestTrace.getPath(), (String)TRACETYPE_ID);
        WaitUtils.waitForJobs();
        fBot.editorByTitle(kernelTestTrace.getName());
        fBot.waitUntil((ICondition)new DefaultCondition((ITmfTrace)kernelTestTrace){
            WidgetNotFoundException fException;
            private final /* synthetic */ ITmfTrace val$kernelTestTrace;
            {
                this.val$kernelTestTrace = iTmfTrace;
            }

            public boolean test() throws Exception {
                try {
                    SWTBotToolbarDropDownButton toolbarDropDownButton = originalViewBot.toolbarDropDownButton(NewCounterViewPinAndCloneTest.PIN_VIEW_BUTTON_NAME);
                    toolbarDropDownButton.menuItem(NewCounterViewPinAndCloneTest.PIN_TO_PREFIX + this.val$kernelTestTrace.getName());
                    toolbarDropDownButton.menuItem(NewCounterViewPinAndCloneTest.PIN_TO_PREFIX + NewCounterViewPinAndCloneTest.this.getTestTrace().getName()).click();
                    return true;
                }
                catch (WidgetNotFoundException e) {
                    this.fException = e;
                    return false;
                }
            }

            public String getFailureMessage() {
                return "Traces not available in toolbar drop down menu: " + String.valueOf((Object)this.fException);
            }
        });
        this.assertOriginalViewTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((String)"There should be an active trace", (Object)activeTrace);
        Assert.assertEquals((String)"context-switches-kernel should be the active trace", (Object)kernelTestTrace.getName(), (Object)activeTrace.getName());
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace kernelTrace = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)kernelTrace);
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)this.getTestTrace().getName());
        this.assertOriginalViewTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)kernelTestTrace.getName());
        this.assertOriginalViewTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        IViewPart viewPart = originalViewBot.getViewReference().getView(false);
        Assert.assertTrue((boolean)(viewPart instanceof TmfChartView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)NewCounterViewPinAndCloneTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, RANGE, kernelTrace));
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)this.getTestTrace().getName());
        SWTBotUtils.waitUntil(v -> v.getWindowStartTime() == 1363700740555978750L && v.getWindowEndTime() == 1363700740655978750L, (Object)chartViewer, (String)"Range of cloned view changed");
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)kernelTrace.getName());
        originalViewBot.toolbarButton(UNPIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(COUNTERS_VIEW_TITLE);
        originalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        this.assertOriginalViewTitle(PINNED_TO_CTX_SWITCH_VIEW_TITLE);
        SWTBotEditor kernelTable = fBot.editorByTitle(kernelTestTrace.getName());
        kernelTable.close();
        SWTBotUtils.waitUntil(v -> ((IViewReference)v.getReference()).getPartName().equals(COUNTERS_VIEW_TITLE), (Object)originalViewBot, (String)"View name didn't change");
        kernelTestTrace.dispose();
    }

    @Test
    public void testCloneSingleTrace() {
        SWTBotView originalViewBot = this.getSWTBotView();
        SWTBotMenu cloneMenu = originalViewBot.viewMenu().menu(new String[]{NEW_COUNTER_STACK_MENU});
        cloneMenu.menu(PINNED_TO_PREFIX + this.getTestTrace().getName()).click();
        this.assertOriginalViewTitle(COUNTERS_VIEW_TITLE);
        SWTBotView clonedView = fBot.viewByTitle(PINNED_TO_TRACE_COUNTERS_VIEW_TITLE);
        Assert.assertEquals((String)"Should not have created a new instance", (long)1L, (long)fBot.editors().size());
        clonedView.close();
        cloneMenu.menu(PINNED_TO_PREFIX + this.getTestTrace().getName() + " | new instance").click();
        this.assertOriginalViewTitle(COUNTERS_VIEW_TITLE);
        clonedView = fBot.viewByTitle(CLONED_VIEW_TITLE_NAME);
        Assert.assertEquals((String)"Should have created a new instance", (long)2L, (long)fBot.editors().size());
        SWTBotEditor cloneEditor = fBot.editorByTitle(this.getTestTrace().getName() + CLONED_TRACE_SUFFIX);
        TmfTraceManager traceManager = TmfTraceManager.getInstance();
        ITmfTrace cloneTrace = traceManager.getActiveTrace();
        Assert.assertNotNull((Object)cloneTrace);
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)this.getTestTrace().getName());
        originalViewBot.toolbarButton(PIN_VIEW_BUTTON_NAME).click();
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)(cloneTrace.getName() + CLONED_TRACE_SUFFIX));
        IViewPart viewPart = clonedView.getViewReference().getView(false);
        Assert.assertTrue((boolean)(viewPart instanceof TmfChartView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)NewCounterViewPinAndCloneTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, RANGE, this.getTestTrace()));
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        SWTBotUtils.waitUntil(v -> v.getWindowStartTime() == 1363700740555978750L && v.getWindowEndTime() == 1363700740655978750L, (Object)chartViewer, (String)"Range of cloned view changed");
        cloneEditor.close();
    }

    private void assertOriginalViewTitle(String newName) {
        Widget expectedWidget = this.getSWTBotView().getWidget();
        Assert.assertNotNull((Object)expectedWidget);
        SWTBotView actualView = fBot.viewByTitle(newName);
        Widget actualWidget = actualView.getWidget();
        Assert.assertNotNull((Object)actualWidget);
        Assert.assertEquals((Object)expectedWidget, (Object)actualWidget);
    }

    protected @NonNull String getMainSeriesName() {
        return MAIN_SERIES_NAME;
    }

    protected @NonNull String getTitle() {
        return COUNTERS_VIEW_TITLE;
    }

    protected String getViewID() {
        return COUNTERS_VIEW_ID;
    }

    protected ITmfTrace getTestTrace() {
        return CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.KERNEL_VM);
    }
}

