/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory;

import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.MemoryPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.FilterTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class MemoryUsageTreeViewer2
extends AbstractSelectTreeViewer2 {
    private boolean fFiltered = true;
    private MemoryPresentationProvider fPresentationProvider;

    public MemoryUsageTreeViewer2(Composite parent, String id) {
        super(parent, 2, id);
        this.setLabelProvider((IBaseLabelProvider)new MemoryLabelProvider());
    }

    protected @NonNull Map<String, Object> getParameters(long start, long end, boolean isSelection) {
        return FetchParametersUtils.filteredTimeQueryToMap((FilterTimeQueryFilter)new FilterTimeQueryFilter(Long.min(start, end), Long.max(start, end), 2, this.fFiltered));
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return () -> {
            Comparator<TmfGenericTreeEntry> compareTid = Comparator.comparingInt(c -> ((MemoryUsageTreeModel)c.getModel()).getTid());
            return ImmutableList.of((Object)MemoryUsageTreeViewer2.createColumn((String)Messages.MemoryUsageTree_ColumnProcess, Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)MemoryUsageTreeViewer2.createColumn((String)Messages.MemoryUsageTree_ColumnTID, compareTid), (Object)new TmfTreeColumnData(Messages.MemoryUsageTree_Legend));
        };
    }

    public void setFiltered(boolean isFiltered) {
        this.fFiltered = isFiltered;
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        this.fPresentationProvider = MemoryPresentationProvider.getForTrace(signal.getTrace());
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        super.traceOpened(signal);
        this.fPresentationProvider = MemoryPresentationProvider.getForTrace(signal.getTrace());
    }

    protected ITmfTreeViewerEntry modelToTree(long start, long end, List<ITmfTreeDataModel> model) {
        for (ITmfTreeDataModel entryModel : model) {
            if (entryModel.getParentId() != -1L) continue;
            this.fPresentationProvider.addTotalSeries(entryModel.getId());
        }
        return super.modelToTree(start, end, model);
    }

    private class MemoryLabelProvider
    extends AbstractSelectTreeViewer2.DataProviderTreeLabelProvider {
        private MemoryLabelProvider() {
            super((AbstractSelectTreeViewer2)MemoryUsageTreeViewer2.this);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof TmfGenericTreeEntry)) {
                return null;
            }
            TmfGenericTreeEntry obj = (TmfGenericTreeEntry)element;
            if (columnIndex == 0) {
                return obj.getName();
            }
            if (columnIndex == 1) {
                int tid = ((MemoryUsageTreeModel)obj.getModel()).getTid();
                if (((MemoryUsageTreeModel)obj.getModel()).getParentId() == -1L) {
                    return Messages.MemoryUsageTree_Total;
                }
                return Integer.toString(tid);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 2 || !(element instanceof TmfGenericTreeEntry)) {
                return null;
            }
            TmfGenericTreeEntry obj = (TmfGenericTreeEntry)element;
            if (MemoryUsageTreeViewer2.this.isChecked(element) || ((MemoryUsageTreeModel)obj.getModel()).getParentId() == -1L) {
                TmfGenericTreeEntry entry = (TmfGenericTreeEntry)element;
                return MemoryUsageTreeViewer2.this.getLegendImage(((MemoryUsageTreeModel)entry.getModel()).getId());
            }
            return null;
        }
    }
}

