/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.docbook;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.vex.core.internal.dom.Document;
import org.eclipse.vex.core.internal.dom.Element;
import org.eclipse.vex.ui.internal.editor.VexEditor;
import org.eclipse.vex.ui.internal.outline.IOutlineProvider;

public class DocBookOutlineProvider
implements IOutlineProvider {
    private final ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return DocBookOutlineProvider.this.getOutlineChildren((Element)parentElement);
        }

        public Object getParent(Object element) {
            Element parent = ((Element)element).getParent();
            if (parent == null) {
                return element;
            }
            return DocBookOutlineProvider.this.getOutlineElement(parent);
        }

        public boolean hasChildren(Object element) {
            return DocBookOutlineProvider.this.getOutlineChildren((Element)element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            Document document = (Document)inputElement;
            return new Object[]{document.getRootElement()};
        }
    };
    private final ILabelProvider labelProvider = new LabelProvider(){

        public String getText(Object o) {
            Element e = (Element)o;
            Element titleChild = DocBookOutlineProvider.this.findChild(e, "title");
            if (titleChild != null) {
                return titleChild.getText();
            }
            Element infoChild = DocBookOutlineProvider.this.findChild(e, String.valueOf(e.getLocalName()) + "info");
            if (infoChild != null && (titleChild = DocBookOutlineProvider.this.findChild(infoChild, "title")) != null) {
                return titleChild.getText();
            }
            return e.getLocalName();
        }
    };
    private static final int MAPSIZE = 101;
    private static final HashSet<String> titledElements = new HashSet(101);

    static {
        titledElements.add("abstract");
        titledElements.add("article");
        titledElements.add("appendix");
        titledElements.add("chapter");
        titledElements.add("glossary");
        titledElements.add("part");
        titledElements.add("partintro");
        titledElements.add("preface");
        titledElements.add("sect1");
        titledElements.add("sect2");
        titledElements.add("sect3");
        titledElements.add("sect4");
        titledElements.add("sect5");
        titledElements.add("section");
        titledElements.add("simplesect");
        titledElements.add("toc");
    }

    public void init(VexEditor editor) {
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Element getOutlineElement(Element child) {
        Element element = child;
        while (element.getParent() != null && !this.isTitledElement(element)) {
            element = element.getParent();
        }
        return element;
    }

    private Element[] getOutlineChildren(Element element) {
        ArrayList<Element> children = new ArrayList<Element>();
        for (Element child : element.getChildElements()) {
            if (!titledElements.contains(child.getLocalName())) continue;
            children.add(child);
        }
        return children.toArray(new Element[children.size()]);
    }

    private boolean isTitledElement(Element e) {
        List children;
        return (titledElements.contains(e.getLocalName()) || e.getParent() == null) && ((children = e.getChildElements()).size() > 0 && ((Element)children.get(0)).getLocalName().equals("title") || children.size() > 1 && ((Element)children.get(1)).getLocalName().equals("title"));
    }

    private Element findChild(Element parent, String childName) {
        for (Element child : parent.getChildElements()) {
            if (!child.getLocalName().equals(childName)) continue;
            return child;
        }
        return null;
    }
}

