/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.net.URI;
import org.eclipse.vex.ui.internal.config.ConfigSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigItem
implements Comparable<ConfigItem> {
    private String id;
    private String name;
    private URI resourceUri;
    private final ConfigSource config;

    public ConfigItem(ConfigSource config) {
        this.config = config;
    }

    @Override
    public int compareTo(ConfigItem o) {
        return this.getName().compareTo(o.getName());
    }

    public String generateSimpleId() {
        int i = 1;
        while (true) {
            String id = "id" + i;
            if (this.getConfig().getItem(id) == null) {
                return id;
            }
            ++i;
        }
    }

    public ConfigSource getConfig() {
        return this.config;
    }

    public abstract String getExtensionPointId();

    public String getSimpleId() {
        return this.id;
    }

    public String getUniqueId() {
        return this.id == null ? null : String.valueOf(this.getConfig().getUniqueIdentifer()) + "." + this.id;
    }

    public String getName() {
        return this.name;
    }

    public URI getResourceUri() {
        return this.resourceUri;
    }

    protected boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public boolean isValid() {
        return !this.isBlank(this.id) && !this.isBlank(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResourceUri(URI resourceUri) {
        this.resourceUri = resourceUri;
    }

    public void setSimpleId(String id) {
        this.id = id;
    }
}

