/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationElementWrapper;
import org.eclipse.vex.ui.internal.config.Messages;

public class ConfigPlugin
extends ConfigSource {
    private final String bundleSymbolicName;

    public ConfigPlugin(String bundleSymbolicName) {
        super(bundleSymbolicName);
        this.bundleSymbolicName = bundleSymbolicName;
        this.load();
    }

    private void load() {
        this.removeAllItems();
        IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensions(this.bundleSymbolicName);
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            try {
                this.addItem(extension.getExtensionPointUniqueIdentifier(), extension.getSimpleIdentifier(), extension.getLabel(), ConfigurationElementWrapper.convertArray(extension.getConfigurationElements()));
            }
            catch (IOException e) {
                String message = MessageFormat.format(Messages.getString("ConfigPlugin.loadError"), extension.getSimpleIdentifier(), this.bundleSymbolicName);
                VexPlugin.getDefault().log(4, message, e);
                return;
            }
            ++n2;
        }
        this.parseResources(null);
    }

    public URL getBaseUrl() {
        return Platform.getBundle((String)this.bundleSymbolicName).getEntry("plugin.xml");
    }
}

