/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.vex.core.internal.core.ListenerList;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.ConfigItem;
import org.eclipse.vex.ui.internal.config.ConfigSource;
import org.eclipse.vex.ui.internal.config.ConfigurationLoader;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.PluginProject;
import org.eclipse.vex.ui.internal.config.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationRegistryImpl
implements ConfigurationRegistry {
    private final ConfigurationLoader loader;
    private volatile boolean loaded = false;
    private final ILock lock = Job.getJobManager().newLock();
    private Map<String, ConfigSource> configurationSources = new HashMap<String, ConfigSource>();
    private final ListenerList<IConfigListener, ConfigEvent> configListeners = new ListenerList(IConfigListener.class);
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                PluginProject pluginProject = ConfigurationRegistryImpl.this.getPluginProject((IProject)event.getResource());
                if (pluginProject != null) {
                    ConfigurationRegistryImpl.this.removeConfigSource(pluginProject);
                    ConfigurationRegistryImpl.this.fireConfigChanged(new ConfigEvent(this));
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] resources;
                IResourceDelta[] iResourceDeltaArray = resources = event.getDelta().getAffectedChildren();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta delta = iResourceDeltaArray[n2];
                    if (delta.getResource() instanceof IProject) {
                        IProject project = (IProject)delta.getResource();
                        PluginProject pluginProject = ConfigurationRegistryImpl.this.getPluginProject(project);
                        if (!project.isOpen() && pluginProject != null) {
                            ConfigurationRegistryImpl.this.removeConfigSource(pluginProject);
                            ConfigurationRegistryImpl.this.fireConfigChanged(new ConfigEvent(this));
                        } else if (PluginProject.isOpenPluginProject(project)) {
                            if (pluginProject == null) {
                                ConfigurationRegistryImpl.this.reloadPluginProject(ConfigurationRegistryImpl.this.addNewPluginProject(project));
                            } else {
                                ConfigurationRegistryImpl.this.reloadPluginProject(pluginProject);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    };

    public ConfigurationRegistryImpl(ConfigurationLoader loader) {
        this.loader = loader;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    @Override
    public void loadConfigurations() {
        this.lock.acquire();
        try {
            this.loader.load(new Runnable(){

                public void run() {
                    ConfigurationRegistryImpl.this.lock.acquire();
                    try {
                        ConfigurationRegistryImpl.this.configurationSources = new HashMap();
                        for (ConfigSource configSource : ConfigurationRegistryImpl.this.loader.getLoadedConfigSources()) {
                            ConfigurationRegistryImpl.this.configurationSources.put(configSource.getUniqueIdentifer(), configSource);
                        }
                        ConfigurationRegistryImpl.this.loaded = true;
                    }
                    finally {
                        ConfigurationRegistryImpl.this.lock.release();
                    }
                    ConfigurationRegistryImpl.this.fireConfigLoaded(new ConfigEvent(ConfigurationRegistryImpl.this));
                }
            });
        }
        finally {
            this.lock.release();
        }
    }

    private List<ConfigItem> getAllConfigItems(String extensionPointId) {
        this.waitUntilLoaded();
        this.lock.acquire();
        try {
            ArrayList<ConfigItem> result = new ArrayList<ConfigItem>();
            for (ConfigSource configurationSource : this.configurationSources.values()) {
                result.addAll(configurationSource.getValidItems(extensionPointId));
            }
            ArrayList<ConfigItem> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    private List<ConfigSource> getAllConfigSources() {
        this.waitUntilLoaded();
        this.lock.acquire();
        try {
            ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
            result.addAll(this.configurationSources.values());
            ArrayList<ConfigSource> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.release();
        }
    }

    private PluginProject addNewPluginProject(IProject project) {
        PluginProject result = new PluginProject(project);
        this.addConfigSource(result);
        return result;
    }

    private void addConfigSource(ConfigSource configSource) {
        this.waitUntilLoaded();
        this.lock.acquire();
        try {
            this.configurationSources.put(configSource.getUniqueIdentifer(), configSource);
        }
        finally {
            this.lock.release();
        }
    }

    private void removeConfigSource(ConfigSource configSource) {
        this.waitUntilLoaded();
        this.lock.acquire();
        try {
            this.configurationSources.remove(configSource.getUniqueIdentifer());
        }
        finally {
            this.lock.release();
        }
    }

    private void waitUntilLoaded() {
        if (this.loaded) {
            return;
        }
        if (!this.loader.isLoading()) {
            throw new IllegalStateException("The configurations are not loaded yet. Call 'loadConfigurations' first.");
        }
        try {
            this.loader.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void addConfigListener(IConfigListener listener) {
        this.configListeners.add((Object)listener);
    }

    @Override
    public void removeConfigListener(IConfigListener listener) {
        this.configListeners.remove((Object)listener);
    }

    private void fireConfigChanged(ConfigEvent e) {
        this.configListeners.fireEvent("configChanged", (EventObject)e);
    }

    private void fireConfigLoaded(ConfigEvent e) {
        this.configListeners.fireEvent("configLoaded", (EventObject)e);
    }

    @Override
    public DocumentType getDocumentType(String publicId) {
        List<ConfigItem> configItems = this.getAllConfigItems("org.eclipse.vex.ui.doctypes");
        for (ConfigItem configItem : configItems) {
            DocumentType doctype = (DocumentType)configItem;
            if (!doctype.getPublicId().equals(publicId)) continue;
            return doctype;
        }
        return null;
    }

    @Override
    public DocumentType[] getDocumentTypes() {
        ArrayList<DocumentType> result = new ArrayList<DocumentType>();
        for (ConfigItem configItem : this.getAllConfigItems("org.eclipse.vex.ui.doctypes")) {
            result.add((DocumentType)configItem);
        }
        return result.toArray(new DocumentType[result.size()]);
    }

    @Override
    public DocumentType[] getDocumentTypesWithStyles() {
        ArrayList<DocumentType> result = new ArrayList<DocumentType>();
        for (ConfigItem configItem : this.getAllConfigItems("org.eclipse.vex.ui.doctypes")) {
            DocumentType doctype = (DocumentType)configItem;
            if (this.getStyles(doctype.getPublicId()).length <= 0) continue;
            result.add(doctype);
        }
        return result.toArray(new DocumentType[result.size()]);
    }

    @Override
    public Style[] getStyles(String publicId) {
        ArrayList<Style> result = new ArrayList<Style>();
        for (ConfigItem configItem : this.getAllConfigItems("org.eclipse.vex.ui.styles")) {
            Style style = (Style)configItem;
            if (!style.appliesTo(publicId)) continue;
            result.add(style);
        }
        return result.toArray(new Style[result.size()]);
    }

    @Override
    public Style getStyle(String styleId) {
        for (ConfigItem configItem : this.getAllConfigItems("org.eclipse.vex.ui.styles")) {
            Style style = (Style)configItem;
            if (!style.getUniqueId().equals(styleId)) continue;
            return style;
        }
        return null;
    }

    @Override
    public Style getStyle(String publicId, String preferredStyleId) {
        Style[] styles = this.getStyles(publicId);
        if (styles.length == 0) {
            return null;
        }
        if (preferredStyleId != null) {
            Style[] styleArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                Style style = styleArray[n2];
                if (style.getUniqueId().equals(preferredStyleId)) {
                    return style;
                }
                ++n2;
            }
        }
        return styles[0];
    }

    @Override
    public PluginProject getPluginProject(IProject project) {
        for (ConfigSource source : this.getAllConfigSources()) {
            PluginProject pluginProject;
            if (!(source instanceof PluginProject) || !project.equals((Object)(pluginProject = (PluginProject)source).getProject())) continue;
            return pluginProject;
        }
        return null;
    }

    private void reloadPluginProject(PluginProject pluginProject) {
        try {
            pluginProject.load();
        }
        catch (CoreException e) {
            VexPlugin.getDefault().getLog().log(e.getStatus());
        }
        this.fireConfigChanged(new ConfigEvent(this));
    }
}

