/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.ConfigurationRegistry;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.Style;

public class ConfigurationView
extends ViewPart {
    private Composite parentControl;
    private Label loadingLabel;
    private TreeViewer treeViewer;
    private final IConfigListener configListener = new IConfigListener(){

        public void configChanged(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ConfigurationView.this.treeViewer.refresh();
                }
            });
        }

        public void configLoaded(ConfigEvent e) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ConfigurationView.this.loadingLabel.dispose();
                    ConfigurationView.this.createTreeViewer();
                    ConfigurationView.this.parentControl.layout();
                }
            });
        }
    };

    public void createPartControl(Composite parent) {
        this.parentControl = parent;
        VexPlugin.getDefault().getConfigurationRegistry().addConfigListener(this.configListener);
        if (VexPlugin.getDefault().getConfigurationRegistry().isLoaded()) {
            this.createTreeViewer();
        } else {
            this.loadingLabel = new Label(parent, 0);
            this.loadingLabel.setText(Messages.getString("ConfigurationView.loading"));
        }
    }

    public void dispose() {
        super.dispose();
        VexPlugin.getDefault().getConfigurationRegistry().removeConfigListener(this.configListener);
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getTree().setFocus();
        }
    }

    private void createTreeViewer() {
        this.treeViewer = new TreeViewer(this.parentControl, 4);
        this.treeViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)VexPlugin.getDefault().getConfigurationRegistry());
    }

    private static class MyContentProvider
    implements ITreeContentProvider {
        private MyContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ConfigurationRegistry) {
                return VexPlugin.getDefault().getConfigurationRegistry().getDocumentTypes();
            }
            if (parentElement instanceof DocumentType) {
                return VexPlugin.getDefault().getConfigurationRegistry().getStyles(((DocumentType)parentElement).getPublicId());
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof DocumentType) {
                return VexPlugin.getDefault().getConfigurationRegistry();
            }
            if (element instanceof Style) {
                return VexPlugin.getDefault().getConfigurationRegistry().getDocumentType(((Style)element).getDocumentTypes().iterator().next());
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class MyLabelProvider
    extends LabelProvider {
        private MyLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DocumentType) {
                return ((DocumentType)element).getName();
            }
            if (element instanceof Style) {
                return ((Style)element).getName();
            }
            return null;
        }
    }
}

