/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vex.ui.internal.config;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.vex.core.internal.dom.Validator;
import org.eclipse.vex.ui.internal.VexPlugin;
import org.eclipse.vex.ui.internal.config.ConfigEvent;
import org.eclipse.vex.ui.internal.config.DocumentType;
import org.eclipse.vex.ui.internal.config.IConfigListener;
import org.eclipse.vex.ui.internal.config.Messages;
import org.eclipse.vex.ui.internal.config.PluginProject;

public class DoctypePropertyPage
extends PropertyPage {
    private static final int NAME_WIDTH = 150;
    private PluginProject pluginProject;
    private DocumentType doctype;
    private Composite pane;
    private Text nameText;
    private Text publicIdText;
    private Text systemIdText;
    private Table rootElementsTable;
    private IConfigListener configListener;

    protected Control createContents(Composite parent) {
        this.pane = new Composite(parent, 0);
        final IFile file = (IFile)this.getElement();
        this.pluginProject = new PluginProject(file.getProject());
        try {
            this.pluginProject.load();
        }
        catch (CoreException e) {
            VexPlugin.getDefault().getLog().log(e.getStatus());
        }
        this.createPropertySheet();
        this.configListener = new IConfigListener(){

            public void configChanged(ConfigEvent event) {
                try {
                    DoctypePropertyPage.this.pluginProject.load();
                }
                catch (CoreException e) {
                    VexPlugin.getDefault().getLog().log(e.getStatus());
                }
                DoctypePropertyPage.this.doctype = (DocumentType)DoctypePropertyPage.this.pluginProject.getItemForResource((IResource)file);
                DoctypePropertyPage.this.populateRootElements();
            }

            public void configLoaded(ConfigEvent e) {
                DoctypePropertyPage.this.setMessage(DoctypePropertyPage.this.getTitle());
                DoctypePropertyPage.this.populateDoctype();
                DoctypePropertyPage.this.setValid(true);
                try {
                    DoctypePropertyPage.this.pluginProject.writeConfigXml();
                }
                catch (Exception ex) {
                    String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
                    VexPlugin.getDefault().log(4, message, ex);
                }
            }
        };
        VexPlugin.getDefault().getConfigurationRegistry().addConfigListener(this.configListener);
        this.doctype = (DocumentType)this.pluginProject.getItemForResource((IResource)file);
        if (this.doctype == null) {
            this.doctype = new DocumentType(this.pluginProject);
            this.doctype.setResourceUri(file.getLocationURI());
            this.pluginProject.addItem(this.doctype);
        }
        if (this.doctype.getSimpleId() == null || this.doctype.getSimpleId().length() == 0) {
            this.doctype.setSimpleId(this.doctype.generateSimpleId());
        }
        if (VexPlugin.getDefault().getConfigurationRegistry().isLoaded()) {
            this.populateDoctype();
            this.populateRootElements();
        } else {
            this.setValid(false);
            this.setMessage(Messages.getString("DoctypePropertyPage.loading"));
        }
        return this.pane;
    }

    private void createPropertySheet() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.pane.setLayout((Layout)layout);
        Label label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.name"));
        this.nameText = new Text(this.pane, 2048);
        GridData gd = new GridData();
        gd.widthHint = 150;
        this.nameText.setLayoutData((Object)gd);
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.publicId"));
        this.publicIdText = new Text(this.pane, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.publicIdText.setLayoutData((Object)gd);
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.systemId"));
        this.systemIdText = new Text(this.pane, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.systemIdText.setLayoutData((Object)gd);
        label = new Label(this.pane, 0);
        label.setText(Messages.getString("DoctypePropertyPage.rootElements"));
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite tablePane = new Composite(this.pane, 2048);
        gd = new GridData(1808);
        gd.heightHint = 200;
        gd.horizontalSpan = 2;
        tablePane.setLayoutData((Object)gd);
        tablePane.setLayout((Layout)new FillLayout());
        this.rootElementsTable = new Table(tablePane, 32);
    }

    private void populateDoctype() {
        DoctypePropertyPage.setText(this.nameText, this.doctype.getName());
        DoctypePropertyPage.setText(this.publicIdText, this.doctype.getPublicId());
        DoctypePropertyPage.setText(this.systemIdText, this.doctype.getSystemId());
    }

    private static void setText(Text textBox, String text) {
        textBox.setText(text == null ? "" : text);
    }

    private void populateRootElements() {
        Validator validator = (Validator)this.pluginProject.getParsedResource(((IFile)this.getElement()).getLocationURI());
        if (validator != null) {
            List<String> list = Arrays.asList(this.doctype.getRootElements());
            TreeSet<String> selectedRootElements = new TreeSet<String>(list);
            this.rootElementsTable.removeAll();
            ArrayList rootElements = new ArrayList(validator.getValidRootElements());
            Collections.sort(rootElements, new Comparator<QualifiedName>(){

                @Override
                public int compare(QualifiedName name1, QualifiedName name2) {
                    return name1.getLocalName().compareTo(name2.getLocalName());
                }
            });
            for (QualifiedName rootElementName : rootElements) {
                TableItem item = new TableItem(this.rootElementsTable, 0);
                this.setRootElementItemText(item, rootElementName);
                item.setData((Object)rootElementName);
                if (!selectedRootElements.contains(rootElementName.getLocalName())) continue;
                item.setChecked(true);
            }
        } else {
            try {
                this.pluginProject.writeConfigXml();
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
                VexPlugin.getDefault().log(4, message, ex);
            }
        }
    }

    private void setRootElementItemText(TableItem item, QualifiedName rootElementName) {
        if (rootElementName.getQualifier() == null) {
            item.setText(rootElementName.getLocalName());
        } else {
            item.setText(String.valueOf(rootElementName.getLocalName()) + " (" + rootElementName.getQualifier() + ")");
        }
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    public void performApply() {
        this.doctype.setName(this.nameText.getText());
        this.doctype.setPublicId(this.publicIdText.getText());
        this.doctype.setSystemId(this.systemIdText.getText());
        ArrayList<String> selectedRootElements = new ArrayList<String>();
        TableItem[] tableItemArray = this.rootElementsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                selectedRootElements.add(((QualifiedName)item.getData()).getLocalName());
            }
            ++n2;
        }
        this.doctype.setRootElements(selectedRootElements.toArray(new String[selectedRootElements.size()]));
        try {
            this.pluginProject.writeConfigXml();
        }
        catch (Exception ex) {
            String message = MessageFormat.format(Messages.getString("DoctypePropertyPage.errorWritingConfig"), "vex-plugin.xml");
            VexPlugin.getDefault().log(4, message, ex);
        }
    }

    public void performDefaults() {
        super.performDefaults();
        this.populateDoctype();
        this.populateRootElements();
    }

    public void dispose() {
        super.dispose();
        if (this.configListener != null) {
            VexPlugin.getDefault().getConfigurationRegistry().removeConfigListener(this.configListener);
        }
    }
}

